/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ovhai.internal.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.ovhai.internal.api.EmbeddingRequest;
import dev.langchain4j.model.ovhai.internal.api.EmbeddingResponse;
import dev.langchain4j.model.ovhai.internal.api.OvhAiApi;
import dev.langchain4j.model.ovhai.internal.client.OvhAiClient;
import dev.langchain4j.model.ovhai.internal.client.RequestLoggingInterceptor;
import dev.langchain4j.model.ovhai.internal.client.ResponseLoggingInterceptor;
import java.io.IOException;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class DefaultOvhAiClient
extends OvhAiClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final OkHttpClient okHttpClient;
    private final String apiKey;
    private final boolean logResponses;
    private final OvhAiApi ovhAiApi;
    private final String authorizationHeader;

    public static Builder builder() {
        return new Builder();
    }

    DefaultOvhAiClient(Builder builder) {
        if (Utils.isNullOrBlank((String)builder.apiKey)) {
            throw new IllegalArgumentException("OVHcloud API key must be defined. It can be generated here: https://endpoints.ai.cloud.ovh.net/");
        }
        this.apiKey = builder.apiKey;
        this.logResponses = builder.logResponses;
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(builder.timeout).connectTimeout(builder.timeout).readTimeout(builder.timeout).writeTimeout(builder.timeout);
        if (builder.logRequests.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new RequestLoggingInterceptor());
        }
        if (this.logResponses) {
            okHttpClientBuilder.addInterceptor((Interceptor)new ResponseLoggingInterceptor());
        }
        this.okHttpClient = okHttpClientBuilder.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)ValidationUtils.ensureNotBlank((String)builder.baseUrl, (String)"baseUrl"))).client(this.okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)OBJECT_MAPPER)).build();
        this.ovhAiApi = (OvhAiApi)retrofit.create(OvhAiApi.class);
        this.authorizationHeader = "Bearer " + ValidationUtils.ensureNotBlank((String)this.apiKey, (String)"apiKey");
    }

    public EmbeddingResponse embed(EmbeddingRequest request) {
        try {
            Response retrofitResponse = this.ovhAiApi.embed(request, this.authorizationHeader).execute();
            if (retrofitResponse.isSuccessful()) {
                return new EmbeddingResponse((List)retrofitResponse.body());
            }
            throw DefaultOvhAiClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    public static class Builder
    extends OvhAiClient.Builder<DefaultOvhAiClient, Builder> {
        @Override
        public DefaultOvhAiClient build() {
            return new DefaultOvhAiClient(this);
        }
    }
}

