/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.spring;

import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.exception.IllegalConfigurationException;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.service.spring.AiService;
import dev.langchain4j.service.spring.AiServiceFactory;
import dev.langchain4j.service.spring.AiServiceWiringMode;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

public class AiServicesAutoConfig {
    @Bean
    BeanFactoryPostProcessor aiServicesRegisteringBeanFactoryPostProcessor() {
        return beanFactory -> {
            String[] chatLanguageModels = beanFactory.getBeanNamesForType(ChatLanguageModel.class);
            String[] streamingChatLanguageModels = beanFactory.getBeanNamesForType(StreamingChatLanguageModel.class);
            String[] chatMemories = beanFactory.getBeanNamesForType(ChatMemory.class);
            String[] chatMemoryProviders = beanFactory.getBeanNamesForType(ChatMemoryProvider.class);
            String[] contentRetrievers = beanFactory.getBeanNamesForType(ContentRetriever.class);
            String[] retrievalAugmentors = beanFactory.getBeanNamesForType(RetrievalAugmentor.class);
            HashSet<String> tools = new HashSet<String>();
            for (String beanName : beanFactory.getBeanDefinitionNames()) {
                try {
                    Class<?> beanClass = Class.forName(beanFactory.getBeanDefinition(beanName).getBeanClassName());
                    for (Method beanMethod : beanClass.getDeclaredMethods()) {
                        if (!beanMethod.isAnnotationPresent(Tool.class)) continue;
                        tools.add(beanName);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AiServicesAutoConfig.findAiServices(beanFactory).forEach(aiServiceClass -> {
                if (beanFactory.getBeanNamesForType(aiServiceClass).length > 0) {
                    return;
                }
                GenericBeanDefinition aiServiceBeanDefinition = new GenericBeanDefinition();
                aiServiceBeanDefinition.setBeanClass(AiServiceFactory.class);
                aiServiceBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue(aiServiceClass);
                MutablePropertyValues propertyValues = aiServiceBeanDefinition.getPropertyValues();
                AiService aiServiceAnnotation = aiServiceClass.getAnnotation(AiService.class);
                AiServicesAutoConfig.addBeanReference(ChatLanguageModel.class, aiServiceAnnotation, aiServiceAnnotation.chatModel(), chatLanguageModels, "chatModel", "chatLanguageModel", propertyValues);
                AiServicesAutoConfig.addBeanReference(StreamingChatLanguageModel.class, aiServiceAnnotation, aiServiceAnnotation.streamingChatModel(), streamingChatLanguageModels, "streamingChatModel", "streamingChatLanguageModel", propertyValues);
                AiServicesAutoConfig.addBeanReference(ChatMemory.class, aiServiceAnnotation, aiServiceAnnotation.chatMemory(), chatMemories, "chatMemory", "chatMemory", propertyValues);
                AiServicesAutoConfig.addBeanReference(ChatMemoryProvider.class, aiServiceAnnotation, aiServiceAnnotation.chatMemoryProvider(), chatMemoryProviders, "chatMemoryProvider", "chatMemoryProvider", propertyValues);
                AiServicesAutoConfig.addBeanReference(ContentRetriever.class, aiServiceAnnotation, aiServiceAnnotation.contentRetriever(), contentRetrievers, "contentRetriever", "contentRetriever", propertyValues);
                AiServicesAutoConfig.addBeanReference(RetrievalAugmentor.class, aiServiceAnnotation, aiServiceAnnotation.retrievalAugmentor(), retrievalAugmentors, "retrievalAugmentor", "retrievalAugmentor", propertyValues);
                if (aiServiceAnnotation.wiringMode() == AiServiceWiringMode.EXPLICIT) {
                    propertyValues.add("tools", AiServicesAutoConfig.toManagedList(Arrays.asList(aiServiceAnnotation.tools())));
                } else if (aiServiceAnnotation.wiringMode() == AiServiceWiringMode.AUTOMATIC) {
                    propertyValues.add("tools", AiServicesAutoConfig.toManagedList(tools));
                } else {
                    throw Exceptions.illegalArgument((String)("Unknown wiring mode: " + (Object)((Object)aiServiceAnnotation.wiringMode())), (Object[])new Object[0]);
                }
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                registry.registerBeanDefinition(AiServicesAutoConfig.lowercaseFirstLetter(aiServiceClass.getSimpleName()), (BeanDefinition)aiServiceBeanDefinition);
            });
        };
    }

    private static Set<Class<?>> findAiServices(ConfigurableListableBeanFactory beanFactory) {
        String[] applicationBean = beanFactory.getBeanNamesForAnnotation(SpringBootApplication.class);
        BeanDefinition applicationBeanDefinition = beanFactory.getBeanDefinition(applicationBean[0]);
        String basePackage = applicationBeanDefinition.getResolvableType().resolve().getPackage().getName();
        Reflections reflections = new Reflections(basePackage, new Scanner[0]);
        return reflections.getTypesAnnotatedWith(AiService.class);
    }

    private static void addBeanReference(Class<?> beanType, AiService aiServiceAnnotation, String customBeanName, String[] beanNames, String annotationAttributeName, String factoryPropertyName, MutablePropertyValues propertyValues) {
        if (aiServiceAnnotation.wiringMode() == AiServiceWiringMode.EXPLICIT) {
            if (Utils.isNotNullOrBlank((String)customBeanName)) {
                propertyValues.add(factoryPropertyName, (Object)new RuntimeBeanReference(customBeanName));
            }
        } else if (aiServiceAnnotation.wiringMode() == AiServiceWiringMode.AUTOMATIC) {
            if (beanNames.length == 1) {
                propertyValues.add(factoryPropertyName, (Object)new RuntimeBeanReference(beanNames[0]));
            } else if (beanNames.length > 1) {
                throw AiServicesAutoConfig.conflict(beanType, beanNames, annotationAttributeName);
            }
        } else {
            throw Exceptions.illegalArgument((String)("Unknown wiring mode: " + (Object)((Object)aiServiceAnnotation.wiringMode())), (Object[])new Object[0]);
        }
    }

    private static IllegalConfigurationException conflict(Class<?> beanType, Object[] beanNames, String attributeName) {
        return IllegalConfigurationException.illegalConfiguration((String)"Conflict: multiple beans of type %s are found: %s. Please specify which one you wish to wire in the @AiService annotation like this: @AiService(wiringMode = EXPLICIT, %s = \"<beanName>\").", (Object[])new Object[]{beanType.getName(), Arrays.toString(beanNames), attributeName});
    }

    private static String lowercaseFirstLetter(String text) {
        if (Utils.isNullOrBlank((String)text)) {
            return text;
        }
        return text.substring(0, 1).toLowerCase() + text.substring(1);
    }

    private static ManagedList<RuntimeBeanReference> toManagedList(Collection<String> beanNames) {
        ManagedList managedList = new ManagedList();
        for (String beanName : beanNames) {
            managedList.add((Object)new RuntimeBeanReference(beanName));
        }
        return managedList;
    }
}

