/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.spring;

import dev.langchain4j.service.spring.ClassPathAiServiceScanner;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class AiServiceScannerProcessor
implements BeanDefinitionRegistryPostProcessor {
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ClassPathAiServiceScanner classPathAiServiceScanner = new ClassPathAiServiceScanner(registry, false);
        Set<String> basePackages = this.getBasePackages((ConfigurableListableBeanFactory)registry);
        for (String basePackage : basePackages) {
            classPathAiServiceScanner.scan(new String[]{basePackage});
        }
    }

    private Set<String> getBasePackages(ConfigurableListableBeanFactory beanFactory) {
        Class applicationBeanClass;
        SpringBootApplication springBootApplication;
        String[] beanNames;
        LinkedHashSet<String> basePackages = new LinkedHashSet<String>();
        List autoConfigPackages = AutoConfigurationPackages.get((BeanFactory)beanFactory);
        basePackages.addAll(autoConfigPackages);
        for (String beanName : beanNames = beanFactory.getBeanNamesForAnnotation(ComponentScan.class)) {
            ComponentScan componentScan;
            Class beanClass = beanFactory.getType(beanName);
            if (beanClass == null || (componentScan = beanClass.getAnnotation(ComponentScan.class)) == null) continue;
            Collections.addAll(basePackages, componentScan.value());
            Collections.addAll(basePackages, componentScan.basePackages());
            for (Class basePackageClass : componentScan.basePackageClasses()) {
                basePackages.add(basePackageClass.getPackage().getName());
            }
        }
        String[] applicationBeans = beanFactory.getBeanNamesForAnnotation(SpringBootApplication.class);
        if (applicationBeans.length > 0 && (springBootApplication = (SpringBootApplication)AnnotationUtils.findAnnotation((Class)(applicationBeanClass = beanFactory.getType(applicationBeans[0])), SpringBootApplication.class)) != null) {
            Collections.addAll(basePackages, springBootApplication.scanBasePackages());
            for (Class aClass : springBootApplication.scanBasePackageClasses()) {
                basePackages.add(ClassUtils.getPackageName((Class)aClass));
            }
        }
        return basePackages;
    }
}

