/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.spring;

import dev.langchain4j.service.spring.AiService;
import dev.langchain4j.service.spring.ClassPathAiServiceScanner;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Component
public class AiServiceScannerProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private Environment environment;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ClassPathAiServiceScanner scanner = new ClassPathAiServiceScanner(registry, false);
        Set<String> basePackages = this.getBasePackages((ConfigurableListableBeanFactory)registry);
        scanner.scan(StringUtils.toStringArray(basePackages));
        this.removeAiServicesWithInactiveProfiles(registry);
    }

    private Set<String> getBasePackages(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashSet<String> basePackages = new LinkedHashSet<String>();
        List autoConfigPackages = AutoConfigurationPackages.get((BeanFactory)beanFactory);
        basePackages.addAll(autoConfigPackages);
        this.addComponentScanPackages(beanFactory, basePackages);
        return basePackages;
    }

    private void addComponentScanPackages(ConfigurableListableBeanFactory beanFactory, Set<String> collectedBasePackages) {
        beanFactory.getBeansWithAnnotation(ComponentScan.class).forEach((beanName, instance) -> {
            Set componentScans = AnnotatedElementUtils.getMergedRepeatableAnnotations(instance.getClass(), ComponentScan.class);
            for (ComponentScan componentScan : componentScans) {
                LinkedHashSet<String> basePackages = new LinkedHashSet<String>();
                String[] basePackagesArray = componentScan.basePackages();
                for (String pkg : basePackagesArray) {
                    String[] tokenized = StringUtils.tokenizeToStringArray((String)this.environment.resolvePlaceholders(pkg), (String)",; \t\n");
                    Collections.addAll(basePackages, tokenized);
                }
                for (Class clazz : componentScan.basePackageClasses()) {
                    basePackages.add(ClassUtils.getPackageName((Class)clazz));
                }
                if (basePackages.isEmpty()) {
                    basePackages.add(ClassUtils.getPackageName(instance.getClass()));
                }
                collectedBasePackages.addAll(basePackages);
            }
        });
    }

    private void removeAiServicesWithInactiveProfiles(BeanDefinitionRegistry registry) {
        Arrays.stream(registry.getBeanDefinitionNames()).filter(beanName -> {
            try {
                Class<?> beanClass;
                BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
                if (beanDefinition.getBeanClassName() != null && (beanClass = Class.forName(beanDefinition.getBeanClassName())).isAnnotationPresent(AiService.class) && beanClass.isAnnotationPresent(Profile.class)) {
                    Profile profileAnnotation = beanClass.getAnnotation(Profile.class);
                    String[] profiles = profileAnnotation.value();
                    return !this.environment.matchesProfiles(profiles);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return false;
        }).forEach(arg_0 -> ((BeanDefinitionRegistry)registry).removeBeanDefinition(arg_0));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

