/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.vertexai;

import com.google.cloud.vertexai.api.Part;
import com.google.cloud.vertexai.generativeai.preview.PartMaker;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import java.net.URI;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class PartsMapper {
    private static final Map<String, String> EXTENSION_TO_MIME_TYPE = new HashMap<String, String>();

    PartsMapper() {
    }

    static List<Part> map(ChatMessage message) {
        if (message instanceof UserMessage) {
            return ((UserMessage)message).contents().stream().map(PartsMapper::map).collect(Collectors.toList());
        }
        if (message instanceof AiMessage) {
            return Collections.singletonList(Part.newBuilder().setText(((AiMessage)message).text()).build());
        }
        throw Exceptions.illegalArgument((String)(message.type() + " message is not supported by Gemini"), (Object[])new Object[0]);
    }

    private static Part map(Content content) {
        if (content instanceof TextContent) {
            return PartsMapper.map((TextContent)content);
        }
        if (content instanceof ImageContent) {
            return PartsMapper.map((ImageContent)content);
        }
        throw Exceptions.illegalArgument((String)("Unknown content type: " + content), (Object[])new Object[0]);
    }

    private static Part map(TextContent content) {
        return Part.newBuilder().setText(content.text()).build();
    }

    static Part map(ImageContent content) {
        Image image = content.image();
        if (image.url() != null) {
            String mimeType = (String)Utils.getOrDefault((Object)image.mimeType(), () -> PartsMapper.detectMimeType(image.url()));
            if (image.url().getScheme().equals("gs")) {
                return PartMaker.fromMimeTypeAndData((String)mimeType, (Object)image.url());
            }
            return PartMaker.fromMimeTypeAndData((String)mimeType, (Object)Utils.readBytes((String)image.url().toString()));
        }
        return PartMaker.fromMimeTypeAndData((String)image.mimeType(), (Object)Base64.getDecoder().decode(image.base64Data()));
    }

    static String detectMimeType(URI url) {
        String extension;
        String mimeType;
        String[] pathParts = url.getPath().split("\\.");
        if (pathParts.length > 1 && (mimeType = EXTENSION_TO_MIME_TYPE.get(extension = pathParts[pathParts.length - 1].toLowerCase())) != null) {
            return mimeType;
        }
        throw Exceptions.illegalArgument((String)"Unable to detect the MIME type of '%s'. Please provide it explicitly.", (Object[])new Object[]{url});
    }

    static {
        EXTENSION_TO_MIME_TYPE.put("avif", "image/avif");
        EXTENSION_TO_MIME_TYPE.put("bmp", "image/bmp");
        EXTENSION_TO_MIME_TYPE.put("gif", "image/gif");
        EXTENSION_TO_MIME_TYPE.put("jpe", "image/jpeg");
        EXTENSION_TO_MIME_TYPE.put("jpeg", "image/jpeg");
        EXTENSION_TO_MIME_TYPE.put("jpg", "image/jpeg");
        EXTENSION_TO_MIME_TYPE.put("png", "image/png");
        EXTENSION_TO_MIME_TYPE.put("svg", "image/svg+xml");
        EXTENSION_TO_MIME_TYPE.put("tif", "image/tiff");
        EXTENSION_TO_MIME_TYPE.put("tiff", "image/tiff");
        EXTENSION_TO_MIME_TYPE.put("webp", "image/webp");
    }
}

