/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.vertexai;

import com.google.cloud.vertexai.api.Candidate;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.generativeai.preview.ResponseHandler;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.vertexai.FinishReasonMapper;
import dev.langchain4j.model.vertexai.TokenUsageMapper;
import java.util.List;

class StreamingChatResponseBuilder {
    private final StringBuffer contentBuilder = new StringBuffer();
    private volatile TokenUsage tokenUsage;
    private volatile FinishReason finishReason;

    StreamingChatResponseBuilder() {
    }

    void append(GenerateContentResponse partialResponse) {
        Candidate.FinishReason finishReason;
        if (partialResponse == null) {
            return;
        }
        List candidates = partialResponse.getCandidatesList();
        if (candidates.isEmpty() || candidates.get(0) == null) {
            return;
        }
        this.contentBuilder.append(ResponseHandler.getText((GenerateContentResponse)partialResponse));
        if (partialResponse.hasUsageMetadata()) {
            this.tokenUsage = TokenUsageMapper.map(partialResponse.getUsageMetadata());
        }
        if ((finishReason = ResponseHandler.getFinishReason((GenerateContentResponse)partialResponse)) != null) {
            this.finishReason = FinishReasonMapper.map(finishReason);
        }
    }

    Response<AiMessage> build() {
        return Response.from((Object)AiMessage.from((String)this.contentBuilder.toString()), (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
    }
}

