/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.vertexai;

import com.google.cloud.vertexai.VertexAI;
import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.FunctionCall;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.Part;
import com.google.cloud.vertexai.api.Tool;
import com.google.cloud.vertexai.generativeai.GenerativeModel;
import com.google.cloud.vertexai.generativeai.ResponseHandler;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.vertexai.ContentsMapper;
import dev.langchain4j.model.vertexai.FinishReasonMapper;
import dev.langchain4j.model.vertexai.FunctionCallHelper;
import dev.langchain4j.model.vertexai.TokenUsageMapper;
import dev.langchain4j.model.vertexai.spi.VertexAiGeminiChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class VertexAiGeminiChatModel
implements ChatLanguageModel,
Closeable {
    private final GenerativeModel generativeModel;
    private final GenerationConfig generationConfig;
    private final Integer maxRetries;
    private final VertexAI vertexAI;

    public VertexAiGeminiChatModel(String project, String location, String modelName, Float temperature, Integer maxOutputTokens, Integer topK, Float topP, Integer maxRetries) {
        GenerationConfig.Builder generationConfigBuilder = GenerationConfig.newBuilder();
        if (temperature != null) {
            generationConfigBuilder.setTemperature(temperature.floatValue());
        }
        if (maxOutputTokens != null) {
            generationConfigBuilder.setMaxOutputTokens(maxOutputTokens.intValue());
        }
        if (topK != null) {
            generationConfigBuilder.setTopK((float)topK.intValue());
        }
        if (topP != null) {
            generationConfigBuilder.setTopP(topP.floatValue());
        }
        this.generationConfig = generationConfigBuilder.build();
        this.vertexAI = new VertexAI(ValidationUtils.ensureNotBlank((String)project, (String)"project"), ValidationUtils.ensureNotBlank((String)location, (String)"location"));
        this.generativeModel = new GenerativeModel(ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName"), this.vertexAI).withGenerationConfig(this.generationConfig);
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public VertexAiGeminiChatModel(GenerativeModel generativeModel, GenerationConfig generationConfig) {
        this(generativeModel, generationConfig, 3);
    }

    public VertexAiGeminiChatModel(GenerativeModel generativeModel, GenerationConfig generationConfig, Integer maxRetries) {
        this.generationConfig = (GenerationConfig)ValidationUtils.ensureNotNull((Object)generationConfig, (String)"generationConfig");
        this.generativeModel = ((GenerativeModel)ValidationUtils.ensureNotNull((Object)generativeModel, (String)"generativeModel")).withGenerationConfig(generationConfig);
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.vertexAI = null;
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        ContentsMapper.InstructionAndContent instructionAndContent = ContentsMapper.splitInstructionAndContent(messages);
        GenerativeModel model = instructionAndContent.systemInstruction != null ? this.generativeModel.withSystemInstruction(instructionAndContent.systemInstruction) : this.generativeModel;
        GenerateContentResponse response = (GenerateContentResponse)RetryUtils.withRetry(() -> model.generateContent(instructionAndContent.contents), (int)this.maxRetries);
        return Response.from((Object)AiMessage.from((String)ResponseHandler.getText((GenerateContentResponse)response)), (TokenUsage)TokenUsageMapper.map(response.getUsageMetadata()), (FinishReason)FinishReasonMapper.map(ResponseHandler.getFinishReason((GenerateContentResponse)response)));
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ContentsMapper.InstructionAndContent instructionAndContent;
        Tool tool = FunctionCallHelper.convertToolSpecifications(toolSpecifications);
        GenerativeModel modelWithTools = this.generativeModel.withTools(Collections.singletonList(tool));
        GenerativeModel model = instructionAndContent.systemInstruction != null ? modelWithTools.withSystemInstruction(instructionAndContent.systemInstruction) : modelWithTools;
        GenerateContentResponse response = (GenerateContentResponse)RetryUtils.withRetry(() -> VertexAiGeminiChatModel.lambda$generate$1(model, instructionAndContent = ContentsMapper.splitInstructionAndContent(messages)), (int)this.maxRetries);
        Content content = ResponseHandler.getContent((GenerateContentResponse)response);
        List<FunctionCall> functionCalls = content.getPartsList().stream().filter(Part::hasFunctionCall).map(Part::getFunctionCall).collect(Collectors.toList());
        if (!functionCalls.isEmpty()) {
            List<ToolExecutionRequest> toolExecutionRequests = FunctionCallHelper.fromFunctionCalls(functionCalls);
            return Response.from((Object)AiMessage.from(toolExecutionRequests), (TokenUsage)TokenUsageMapper.map(response.getUsageMetadata()), (FinishReason)FinishReasonMapper.map(ResponseHandler.getFinishReason((GenerateContentResponse)response)));
        }
        return Response.from((Object)AiMessage.from((String)ResponseHandler.getText((GenerateContentResponse)response)), (TokenUsage)TokenUsageMapper.map(response.getUsageMetadata()), (FinishReason)FinishReasonMapper.map(ResponseHandler.getFinishReason((GenerateContentResponse)response)));
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        if (toolSpecification == null) {
            return this.generate(messages);
        }
        return this.generate(messages, Collections.singletonList(toolSpecification));
    }

    public static VertexAiGeminiChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(VertexAiGeminiChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            VertexAiGeminiChatModelBuilderFactory factory = (VertexAiGeminiChatModelBuilderFactory)iterator.next();
            return (VertexAiGeminiChatModelBuilder)factory.get();
        }
        return new VertexAiGeminiChatModelBuilder();
    }

    @Override
    public void close() throws IOException {
        if (this.vertexAI != null) {
            this.vertexAI.close();
        }
    }

    private static /* synthetic */ GenerateContentResponse lambda$generate$1(GenerativeModel model, ContentsMapper.InstructionAndContent instructionAndContent) throws Exception {
        return model.generateContent(instructionAndContent.contents);
    }

    public static class VertexAiGeminiChatModelBuilder {
        private String project;
        private String location;
        private String modelName;
        private Float temperature;
        private Integer maxOutputTokens;
        private Integer topK;
        private Float topP;
        private Integer maxRetries;

        public VertexAiGeminiChatModelBuilder project(String project) {
            this.project = project;
            return this;
        }

        public VertexAiGeminiChatModelBuilder location(String location) {
            this.location = location;
            return this;
        }

        public VertexAiGeminiChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public VertexAiGeminiChatModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public VertexAiGeminiChatModelBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        public VertexAiGeminiChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public VertexAiGeminiChatModelBuilder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        public VertexAiGeminiChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public VertexAiGeminiChatModel build() {
            return new VertexAiGeminiChatModel(this.project, this.location, this.modelName, this.temperature, this.maxOutputTokens, this.topK, this.topP, this.maxRetries);
        }

        public String toString() {
            return "VertexAiGeminiChatModel.VertexAiGeminiChatModelBuilder(project=" + this.project + ", location=" + this.location + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", maxOutputTokens=" + this.maxOutputTokens + ", topK=" + this.topK + ", topP=" + this.topP + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

