/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.vertexai;

import com.google.cloud.vertexai.api.Schema;
import com.google.cloud.vertexai.api.Type;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SchemaHelper {
    public static Schema fromJsonSchema(String jsonSchemaString) {
        try {
            String schemaJsonString = jsonSchemaString.replace("\"object\"", "\"OBJECT\"").replace("\"integer\"", "\"INTEGER\"").replace("\"string\"", "\"STRING\"").replace("\"number\"", "\"NUMBER\"").replace("\"array\"", "\"ARRAY\"").replace("\"boolean\"", "\"BOOLEAN\"");
            Schema.Builder builder = Schema.newBuilder();
            JsonFormat.parser().merge(schemaJsonString, (Message.Builder)builder);
            return builder.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static Schema fromClass(Class<?> theClass) {
        if (CharSequence.class.isAssignableFrom(theClass) || Character.class.isAssignableFrom(theClass) || Character.TYPE.isAssignableFrom(theClass)) {
            return Schema.newBuilder().setType(Type.STRING).build();
        }
        if (Boolean.class.isAssignableFrom(theClass) || Boolean.TYPE.isAssignableFrom(theClass)) {
            return Schema.newBuilder().setType(Type.BOOLEAN).build();
        }
        if (Integer.class.isAssignableFrom(theClass) || Integer.TYPE.isAssignableFrom(theClass) || Long.class.isAssignableFrom(theClass) || Long.TYPE.isAssignableFrom(theClass)) {
            return Schema.newBuilder().setType(Type.INTEGER).build();
        }
        if (Double.class.isAssignableFrom(theClass) || Double.TYPE.isAssignableFrom(theClass) || Float.class.isAssignableFrom(theClass) || Float.TYPE.isAssignableFrom(theClass)) {
            return Schema.newBuilder().setType(Type.NUMBER).build();
        }
        if (theClass.isArray()) {
            Class<?> componentType = theClass.getComponentType();
            return Schema.newBuilder().setType(Type.ARRAY).setItems(SchemaHelper.fromClass(componentType)).build();
        }
        if (Collection.class.isAssignableFrom(theClass)) {
            return Schema.newBuilder().setType(Type.ARRAY).build();
        }
        if (theClass.isEnum()) {
            List enumConstantNames = Arrays.stream(theClass.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
            return Schema.newBuilder().setType(Type.STRING).addAllEnum(enumConstantNames).build();
        }
        Schema.Builder schemaBuilder = Schema.newBuilder().setType(Type.OBJECT);
        ArrayList propertyNames = new ArrayList();
        Stream.concat(Arrays.stream(theClass.getDeclaredFields()), Arrays.stream(theClass.getFields())).filter(field -> !field.getName().startsWith("this$")).collect(Collectors.toSet()).forEach(field -> {
            schemaBuilder.putProperties(field.getName(), SchemaHelper.fromClass(field.getType())).build();
            propertyNames.add(field.getName());
        });
        schemaBuilder.addAllRequired(propertyNames);
        return schemaBuilder.build();
    }
}

