/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.vertexai;

import com.google.cloud.vertexai.api.FunctionCall;
import com.google.cloud.vertexai.api.FunctionDeclaration;
import com.google.cloud.vertexai.api.Schema;
import com.google.cloud.vertexai.api.Tool;
import com.google.cloud.vertexai.api.Type;
import com.google.gson.Gson;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.google.protobuf.util.JsonFormat;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class FunctionCallHelper {
    private static final Gson GSON = new Gson();

    FunctionCallHelper() {
    }

    static Type fromType(String type) {
        switch (type) {
            case "string": {
                return Type.STRING;
            }
            case "integer": {
                return Type.INTEGER;
            }
            case "boolean": {
                return Type.BOOLEAN;
            }
            case "number": {
                return Type.NUMBER;
            }
            case "array": {
                return Type.ARRAY;
            }
            case "object": {
                return Type.OBJECT;
            }
        }
        return Type.TYPE_UNSPECIFIED;
    }

    static FunctionCall fromToolExecutionRequest(ToolExecutionRequest toolExecutionRequest) {
        FunctionCall.Builder fnCallBuilder = FunctionCall.newBuilder().setName(toolExecutionRequest.name());
        Struct.Builder structBuilder = Struct.newBuilder();
        try {
            JsonFormat.parser().merge(toolExecutionRequest.arguments(), (Message.Builder)structBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        Struct argsStruct = structBuilder.build();
        fnCallBuilder.setArgs(argsStruct);
        return fnCallBuilder.build();
    }

    static List<ToolExecutionRequest> fromFunctionCalls(List<FunctionCall> functionCalls) {
        ArrayList<ToolExecutionRequest> toolExecutionRequests = new ArrayList<ToolExecutionRequest>();
        for (FunctionCall functionCall : functionCalls) {
            ToolExecutionRequest.Builder builder = ToolExecutionRequest.builder().name(functionCall.getName());
            HashMap callArgsMap = new HashMap();
            Struct callArgs = functionCall.getArgs();
            Map callArgsFieldsMap = callArgs.getFieldsMap();
            callArgsFieldsMap.forEach((key, value) -> callArgsMap.put(key, FunctionCallHelper.unwrapProtoValue(value)));
            String serializedArgsMap = GSON.toJson(callArgsMap);
            builder.arguments(serializedArgsMap);
            toolExecutionRequests.add(builder.build());
        }
        return toolExecutionRequests;
    }

    static Object unwrapProtoValue(Value value) {
        Object unwrappedValue;
        switch (value.getKindCase()) {
            case NUMBER_VALUE: {
                unwrappedValue = value.getNumberValue();
                break;
            }
            case STRING_VALUE: {
                unwrappedValue = value.getStringValue();
                break;
            }
            case BOOL_VALUE: {
                unwrappedValue = value.getBoolValue();
                break;
            }
            case STRUCT_VALUE: {
                HashMap mapForStruct = new HashMap();
                value.getStructValue().getFieldsMap().forEach((key, val) -> mapForStruct.put(key, FunctionCallHelper.unwrapProtoValue(val)));
                unwrappedValue = mapForStruct;
                break;
            }
            case LIST_VALUE: {
                unwrappedValue = value.getListValue().getValuesList().stream().map(FunctionCallHelper::unwrapProtoValue).collect(Collectors.toList());
                break;
            }
            default: {
                unwrappedValue = null;
            }
        }
        return unwrappedValue;
    }

    static Tool convertToolSpecifications(List<ToolSpecification> toolSpecifications) {
        Tool.Builder tool = Tool.newBuilder();
        for (ToolSpecification toolSpecification : toolSpecifications) {
            FunctionDeclaration.Builder fnBuilder = FunctionDeclaration.newBuilder().setName(toolSpecification.name());
            if (toolSpecification.description() != null) {
                fnBuilder.setDescription(toolSpecification.description());
            }
            Schema.Builder schema = Schema.newBuilder().setType(Type.OBJECT);
            ToolParameters parameters = toolSpecification.parameters();
            if (parameters != null) {
                for (String paramName2 : parameters.required()) {
                    schema.addRequired(paramName2);
                }
                parameters.properties().forEach((paramName, paramProps) -> {
                    Type type = FunctionCallHelper.fromType((String)paramProps.getOrDefault("type", Type.TYPE_UNSPECIFIED));
                    String description = paramProps.getOrDefault("description", "");
                    schema.putProperties(paramName, Schema.newBuilder().setDescription(description).setType(type).build());
                });
            }
            fnBuilder.setParameters(schema.build());
            tool.addFunctionDeclarations(fnBuilder.build());
        }
        return tool.build();
    }
}

