/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.vertexai;

import com.google.cloud.vertexai.api.FunctionCall;
import com.google.cloud.vertexai.api.FunctionDeclaration;
import com.google.cloud.vertexai.api.Tool;
import com.google.gson.Gson;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.google.protobuf.util.JsonFormat;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.vertexai.SchemaHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class FunctionCallHelper {
    private static final Gson GSON = new Gson();

    FunctionCallHelper() {
    }

    static FunctionCall fromToolExecutionRequest(ToolExecutionRequest toolExecutionRequest) {
        FunctionCall.Builder fnCallBuilder = FunctionCall.newBuilder().setName(toolExecutionRequest.name());
        Struct.Builder structBuilder = Struct.newBuilder();
        try {
            JsonFormat.parser().merge(toolExecutionRequest.arguments(), (Message.Builder)structBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        Struct argsStruct = structBuilder.build();
        fnCallBuilder.setArgs(argsStruct);
        return fnCallBuilder.build();
    }

    static List<ToolExecutionRequest> fromFunctionCalls(List<FunctionCall> functionCalls) {
        ArrayList<ToolExecutionRequest> toolExecutionRequests = new ArrayList<ToolExecutionRequest>();
        for (FunctionCall functionCall : functionCalls) {
            ToolExecutionRequest.Builder builder = ToolExecutionRequest.builder().name(functionCall.getName());
            HashMap callArgsMap = new HashMap();
            Struct callArgs = functionCall.getArgs();
            Map callArgsFieldsMap = callArgs.getFieldsMap();
            callArgsFieldsMap.forEach((key, value) -> callArgsMap.put(key, FunctionCallHelper.unwrapProtoValue(value)));
            String serializedArgsMap = GSON.toJson(callArgsMap);
            builder.arguments(serializedArgsMap);
            toolExecutionRequests.add(builder.build());
        }
        return toolExecutionRequests;
    }

    static Object unwrapProtoValue(Value value) {
        return switch (value.getKindCase()) {
            case Value.KindCase.NUMBER_VALUE -> value.getNumberValue();
            case Value.KindCase.STRING_VALUE -> value.getStringValue();
            case Value.KindCase.BOOL_VALUE -> value.getBoolValue();
            case Value.KindCase.STRUCT_VALUE -> {
                HashMap mapForStruct = new HashMap();
                value.getStructValue().getFieldsMap().forEach((key, val) -> mapForStruct.put(key, FunctionCallHelper.unwrapProtoValue(val)));
                yield mapForStruct;
            }
            case Value.KindCase.LIST_VALUE -> value.getListValue().getValuesList().stream().map(FunctionCallHelper::unwrapProtoValue).collect(Collectors.toList());
            default -> null;
        };
    }

    static Tool convertToolSpecifications(List<ToolSpecification> toolSpecifications) {
        Tool.Builder tool = Tool.newBuilder();
        for (ToolSpecification toolSpecification : toolSpecifications) {
            FunctionDeclaration.Builder fnBuilder = FunctionDeclaration.newBuilder().setName(toolSpecification.name());
            if (toolSpecification.description() != null) {
                fnBuilder.setDescription(toolSpecification.description());
            }
            if (toolSpecification.parameters() != null) {
                fnBuilder.setParameters(SchemaHelper.from((JsonSchemaElement)toolSpecification.parameters()));
            }
            tool.addFunctionDeclarations(fnBuilder.build());
        }
        return tool.build();
    }
}

