/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.vertexai;

import com.google.cloud.vertexai.VertexAI;
import com.google.cloud.vertexai.api.FunctionCallingConfig;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.Schema;
import com.google.cloud.vertexai.api.Tool;
import com.google.cloud.vertexai.api.ToolConfig;
import com.google.cloud.vertexai.generativeai.GenerativeModel;
import com.google.cloud.vertexai.generativeai.ResponseHandler;
import com.google.common.annotations.VisibleForTesting;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.ChatRequestValidationUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.vertexai.ContentsMapper;
import dev.langchain4j.model.vertexai.FunctionCallHelper;
import dev.langchain4j.model.vertexai.HarmCategory;
import dev.langchain4j.model.vertexai.ResponseGrounding;
import dev.langchain4j.model.vertexai.SafetySettingsMapper;
import dev.langchain4j.model.vertexai.SafetyThreshold;
import dev.langchain4j.model.vertexai.StreamingChatResponseBuilder;
import dev.langchain4j.model.vertexai.ToolCallingMode;
import dev.langchain4j.model.vertexai.VertexAiGeminiChatModel;
import dev.langchain4j.model.vertexai.spi.VertexAiGeminiStreamingChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexAiGeminiStreamingChatModel
implements StreamingChatModel,
Closeable {
    private final GenerativeModel generativeModel;
    private final GenerationConfig generationConfig;
    private final VertexAI vertexAI;
    private final Map<HarmCategory, SafetyThreshold> safetySettings;
    private final Tool googleSearch;
    private final Tool vertexSearch;
    private final ToolConfig toolConfig;
    private final List<String> allowedFunctionNames;
    private final Boolean logRequests;
    private final Boolean logResponses;
    private static final Logger logger = LoggerFactory.getLogger(VertexAiGeminiChatModel.class);
    private final List<ChatModelListener> listeners;

    public VertexAiGeminiStreamingChatModel(String project, String location, String modelName, Float temperature, Integer maxOutputTokens, Integer topK, Float topP, String responseMimeType, Schema responseSchema, Map<HarmCategory, SafetyThreshold> safetySettings, Boolean useGoogleSearch, String vertexSearchDatastore, ToolCallingMode toolCallingMode, List<String> allowedFunctionNames, Boolean logRequests, Boolean logResponses, List<ChatModelListener> listeners, Map<String, String> customHeaders) {
        Map<String, String> headers;
        GenerationConfig.Builder generationConfigBuilder = GenerationConfig.newBuilder();
        if (temperature != null) {
            generationConfigBuilder.setTemperature(temperature.floatValue());
        }
        if (maxOutputTokens != null) {
            generationConfigBuilder.setMaxOutputTokens(maxOutputTokens.intValue());
        }
        if (topK != null) {
            generationConfigBuilder.setTopK((float)topK.intValue());
        }
        if (topP != null) {
            generationConfigBuilder.setTopP(topP.floatValue());
        }
        if (responseMimeType != null) {
            generationConfigBuilder.setResponseMimeType(responseMimeType);
        }
        if (responseSchema != null) {
            if (responseSchema.getEnumCount() > 0) {
                generationConfigBuilder.setResponseMimeType("text/x.enum");
            } else {
                generationConfigBuilder.setResponseMimeType("application/json");
            }
            generationConfigBuilder.setResponseSchema(responseSchema);
        }
        this.generationConfig = generationConfigBuilder.build();
        this.safetySettings = safetySettings != null ? new HashMap<HarmCategory, SafetyThreshold>(safetySettings) : Collections.emptyMap();
        this.googleSearch = useGoogleSearch != null && useGoogleSearch != false ? ResponseGrounding.googleSearchTool() : null;
        this.vertexSearch = vertexSearchDatastore != null ? ResponseGrounding.vertexAiSearch(vertexSearchDatastore) : null;
        this.allowedFunctionNames = allowedFunctionNames != null ? Collections.unmodifiableList(allowedFunctionNames) : Collections.emptyList();
        this.toolConfig = toolCallingMode != null ? (toolCallingMode == ToolCallingMode.ANY && allowedFunctionNames != null && !allowedFunctionNames.isEmpty() ? ToolConfig.newBuilder().setFunctionCallingConfig(FunctionCallingConfig.newBuilder().setMode(FunctionCallingConfig.Mode.ANY).addAllAllowedFunctionNames(this.allowedFunctionNames).build()).build() : (toolCallingMode == ToolCallingMode.NONE ? ToolConfig.newBuilder().setFunctionCallingConfig(FunctionCallingConfig.newBuilder().setMode(FunctionCallingConfig.Mode.NONE).build()).build() : ToolConfig.newBuilder().setFunctionCallingConfig(FunctionCallingConfig.newBuilder().setMode(FunctionCallingConfig.Mode.AUTO).build()).build())) : ToolConfig.newBuilder().setFunctionCallingConfig(FunctionCallingConfig.newBuilder().setMode(FunctionCallingConfig.Mode.AUTO).build()).build();
        if (customHeaders != null) {
            headers = new HashMap<String, String>(customHeaders);
            headers.putIfAbsent("user-agent", "LangChain4j");
        } else {
            headers = Map.of("user-agent", "LangChain4j");
        }
        this.vertexAI = new VertexAI.Builder().setProjectId(ValidationUtils.ensureNotBlank((String)project, (String)"project")).setLocation(ValidationUtils.ensureNotBlank((String)location, (String)"location")).setCustomHeaders(headers).build();
        this.generativeModel = new GenerativeModel(ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName"), this.vertexAI).withGenerationConfig(this.generationConfig);
        this.logRequests = logRequests != null ? logRequests : Boolean.valueOf(false);
        this.logResponses = logResponses != null ? logResponses : Boolean.valueOf(false);
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
    }

    public VertexAiGeminiStreamingChatModel(GenerativeModel generativeModel, GenerationConfig generationConfig) {
        this.generativeModel = (GenerativeModel)ValidationUtils.ensureNotNull((Object)generativeModel, (String)"generativeModel");
        this.generationConfig = (GenerationConfig)ValidationUtils.ensureNotNull((Object)generationConfig, (String)"generationConfig");
        this.vertexAI = null;
        this.safetySettings = Collections.emptyMap();
        this.googleSearch = null;
        this.vertexSearch = null;
        this.toolConfig = ToolConfig.newBuilder().setFunctionCallingConfig(FunctionCallingConfig.newBuilder().setMode(FunctionCallingConfig.Mode.AUTO).build()).build();
        this.allowedFunctionNames = Collections.emptyList();
        this.logRequests = false;
        this.logResponses = false;
        this.listeners = Collections.emptyList();
    }

    public void chat(ChatRequest chatRequest, final StreamingChatResponseHandler handler) {
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatRequestValidationUtils.validateParameters((ChatRequestParameters)parameters);
        ChatRequestValidationUtils.validate((ToolChoice)parameters.toolChoice());
        ChatRequestValidationUtils.validate((ResponseFormat)parameters.responseFormat());
        StreamingResponseHandler<AiMessage> legacyHandler = new StreamingResponseHandler<AiMessage>(){

            public void onNext(String token) {
                handler.onPartialResponse(token);
            }

            public void onComplete(Response<AiMessage> response) {
                ChatResponse chatResponse = ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
                handler.onCompleteResponse(chatResponse);
            }

            public void onError(Throwable error) {
                handler.onError(error);
            }
        };
        List toolSpecifications = parameters.toolSpecifications();
        if (Utils.isNullOrEmpty((Collection)toolSpecifications)) {
            this.generate(chatRequest.messages(), legacyHandler);
        } else {
            this.generate(chatRequest.messages(), toolSpecifications, legacyHandler);
        }
    }

    private void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, Collections.emptyList(), handler);
    }

    private void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        String modelName = this.generativeModel.getModelName();
        ArrayList<Tool> tools = new ArrayList<Tool>();
        if (toolSpecifications != null && !toolSpecifications.isEmpty()) {
            Tool tool = FunctionCallHelper.convertToolSpecifications(toolSpecifications);
            tools.add(tool);
        }
        if (this.googleSearch != null) {
            tools.add(this.googleSearch);
        }
        if (this.vertexSearch != null) {
            tools.add(this.vertexSearch);
        }
        GenerativeModel model = this.generativeModel.withTools(tools).withToolConfig(this.toolConfig);
        ContentsMapper.InstructionAndContent instructionAndContent = ContentsMapper.splitInstructionAndContent(messages);
        if (instructionAndContent.systemInstruction != null) {
            model = model.withSystemInstruction(instructionAndContent.systemInstruction);
        }
        if (!this.safetySettings.isEmpty()) {
            model = model.withSafetySettings(SafetySettingsMapper.mapSafetySettings(this.safetySettings));
        }
        if (this.logRequests.booleanValue() && logger.isDebugEnabled()) {
            logger.debug("GEMINI ({}) request: {} tools: {}", new Object[]{modelName, instructionAndContent, tools});
        }
        ChatRequest listenerRequest = ChatRequest.builder().messages(messages).parameters(ChatRequestParameters.builder().modelName(modelName).temperature(Double.valueOf(this.generationConfig.getTemperature())).topP(Double.valueOf(this.generationConfig.getTopP())).maxOutputTokens(Integer.valueOf(this.generationConfig.getMaxOutputTokens())).toolSpecifications(toolSpecifications).build()).build();
        ConcurrentHashMap listenerAttributes = new ConcurrentHashMap();
        ChatModelRequestContext chatModelRequestContext = new ChatModelRequestContext(listenerRequest, this.provider(), listenerAttributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(chatModelRequestContext);
            }
            catch (Exception e) {
                logger.warn("Exception while calling model listener (onRequest)", (Throwable)e);
            }
        });
        StreamingChatResponseBuilder responseBuilder = new StreamingChatResponseBuilder();
        try {
            model.generateContentStream(instructionAndContent.contents).stream().forEach(partialResponse -> {
                if (partialResponse.getCandidatesCount() > 0) {
                    responseBuilder.append((GenerateContentResponse)partialResponse);
                    handler.onNext(ResponseHandler.getText((GenerateContentResponse)partialResponse));
                }
            });
            Response<AiMessage> fullResponse = responseBuilder.build();
            handler.onComplete(fullResponse);
            ChatResponse listenerResponse = ChatResponse.builder().aiMessage((AiMessage)fullResponse.content()).metadata(ChatResponseMetadata.builder().modelName(modelName).tokenUsage(fullResponse.tokenUsage()).finishReason(fullResponse.finishReason()).build()).build();
            ChatModelResponseContext chatModelResponseContext = new ChatModelResponseContext(listenerResponse, listenerRequest, this.provider(), listenerAttributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(chatModelResponseContext);
                }
                catch (Exception e) {
                    logger.warn("Exception while calling model listener (onResponse)", (Throwable)e);
                }
            });
            if (this.logResponses.booleanValue() && logger.isDebugEnabled()) {
                logger.debug("GEMINI ({}) response: {}", (Object)modelName, fullResponse);
            }
        }
        catch (Exception exception) {
            this.listeners.forEach(listener -> {
                try {
                    ChatModelErrorContext chatModelErrorContext = new ChatModelErrorContext((Throwable)exception, listenerRequest, this.provider(), (Map)listenerAttributes);
                    listener.onError(chatModelErrorContext);
                }
                catch (Exception t) {
                    logger.warn("Exception while calling model listener (onError)", (Throwable)t);
                }
            });
            handler.onError((Throwable)exception);
        }
    }

    @VisibleForTesting
    VertexAI vertexAI() {
        return this.vertexAI;
    }

    @Override
    public void close() {
        if (this.vertexAI != null) {
            this.vertexAI.close();
        }
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.GOOGLE_VERTEX_AI_GEMINI;
    }

    public static VertexAiGeminiStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(VertexAiGeminiStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            VertexAiGeminiStreamingChatModelBuilderFactory factory = (VertexAiGeminiStreamingChatModelBuilderFactory)iterator.next();
            return (VertexAiGeminiStreamingChatModelBuilder)factory.get();
        }
        return new VertexAiGeminiStreamingChatModelBuilder();
    }

    public static class VertexAiGeminiStreamingChatModelBuilder {
        private String project;
        private String location;
        private String modelName;
        private Float temperature;
        private Integer maxOutputTokens;
        private Integer topK;
        private Float topP;
        private String responseMimeType;
        private Schema responseSchema;
        private Map<HarmCategory, SafetyThreshold> safetySettings;
        private Boolean useGoogleSearch;
        private String vertexSearchDatastore;
        private ToolCallingMode toolCallingMode;
        private List<String> allowedFunctionNames;
        private Boolean logRequests;
        private Boolean logResponses;
        private List<ChatModelListener> listeners;
        private Map<String, String> customHeaders;

        public VertexAiGeminiStreamingChatModelBuilder project(String project) {
            this.project = project;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder location(String location) {
            this.location = location;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder responseMimeType(String responseMimeType) {
            this.responseMimeType = responseMimeType;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder responseSchema(Schema responseSchema) {
            this.responseSchema = responseSchema;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder safetySettings(Map<HarmCategory, SafetyThreshold> safetySettings) {
            this.safetySettings = safetySettings;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder useGoogleSearch(Boolean useGoogleSearch) {
            this.useGoogleSearch = useGoogleSearch;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder vertexSearchDatastore(String vertexSearchDatastore) {
            this.vertexSearchDatastore = vertexSearchDatastore;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder toolCallingMode(ToolCallingMode toolCallingMode) {
            this.toolCallingMode = toolCallingMode;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder allowedFunctionNames(List<String> allowedFunctionNames) {
            this.allowedFunctionNames = allowedFunctionNames;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public VertexAiGeminiStreamingChatModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public VertexAiGeminiStreamingChatModel build() {
            return new VertexAiGeminiStreamingChatModel(this.project, this.location, this.modelName, this.temperature, this.maxOutputTokens, this.topK, this.topP, this.responseMimeType, this.responseSchema, this.safetySettings, this.useGoogleSearch, this.vertexSearchDatastore, this.toolCallingMode, this.allowedFunctionNames, this.logRequests, this.logResponses, this.listeners, this.customHeaders);
        }

        public String toString() {
            return "VertexAiGeminiStreamingChatModel.VertexAiGeminiStreamingChatModelBuilder(project=" + this.project + ", location=" + this.location + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", maxOutputTokens=" + this.maxOutputTokens + ", topK=" + this.topK + ", topP=" + this.topP + ", responseMimeType=" + this.responseMimeType + ", responseSchema=" + String.valueOf(this.responseSchema) + ", safetySettings=" + String.valueOf(this.safetySettings) + ", useGoogleSearch=" + this.useGoogleSearch + ", vertexSearchDatastore=" + this.vertexSearchDatastore + ", toolCallingMode=" + String.valueOf((Object)this.toolCallingMode) + ", allowedFunctionNames=" + String.valueOf(this.allowedFunctionNames) + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", listeners=" + String.valueOf(this.listeners) + ")";
        }
    }
}

