/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.vertexai;

import com.google.cloud.vertexai.api.Candidate;
import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.FunctionCall;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.Part;
import com.google.cloud.vertexai.generativeai.ResponseHandler;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.vertexai.FinishReasonMapper;
import dev.langchain4j.model.vertexai.FunctionCallHelper;
import dev.langchain4j.model.vertexai.TokenUsageMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class StreamingChatResponseBuilder {
    private final StringBuffer contentBuilder = new StringBuffer();
    private final List<FunctionCall> functionCalls = new ArrayList<FunctionCall>();
    private volatile TokenUsage tokenUsage;
    private volatile FinishReason finishReason;

    StreamingChatResponseBuilder() {
    }

    void append(GenerateContentResponse partialResponse) {
        Candidate.FinishReason finishReason;
        if (partialResponse == null) {
            return;
        }
        List candidates = partialResponse.getCandidatesList();
        if (candidates.isEmpty() || candidates.get(0) == null) {
            return;
        }
        List functionCalls = candidates.stream().map(Candidate::getContent).map(Content::getPartsList).flatMap(Collection::stream).filter(Part::hasFunctionCall).map(Part::getFunctionCall).collect(Collectors.toList());
        if (!functionCalls.isEmpty()) {
            this.functionCalls.addAll(functionCalls);
        } else {
            this.contentBuilder.append(ResponseHandler.getText((GenerateContentResponse)partialResponse));
        }
        if (partialResponse.hasUsageMetadata()) {
            this.tokenUsage = TokenUsageMapper.map(partialResponse.getUsageMetadata());
        }
        if ((finishReason = ResponseHandler.getFinishReason((GenerateContentResponse)partialResponse)) != null) {
            this.finishReason = FinishReasonMapper.map(finishReason);
        }
    }

    Response<AiMessage> build() {
        if (!this.functionCalls.isEmpty()) {
            return Response.from((Object)AiMessage.from(FunctionCallHelper.fromFunctionCalls(this.functionCalls)), (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
        }
        return Response.from((Object)AiMessage.from((String)this.contentBuilder.toString()), (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
    }
}

