/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.voyageai;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.voyageai.EmbeddingRequest;
import dev.langchain4j.model.voyageai.EmbeddingResponse;
import dev.langchain4j.model.voyageai.RequestLoggingInterceptor;
import dev.langchain4j.model.voyageai.RerankRequest;
import dev.langchain4j.model.voyageai.RerankResponse;
import dev.langchain4j.model.voyageai.ResponseLoggingInterceptor;
import dev.langchain4j.model.voyageai.VoyageAiApi;
import dev.langchain4j.model.voyageai.VoyageAiJsonUtils;
import java.io.IOException;
import java.time.Duration;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

class VoyageAiClient {
    private final VoyageAiApi voyageAiApi;

    VoyageAiClient(String baseUrl, Duration timeout, String apiKey, Boolean logRequests, Boolean logResponses) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout);
        okHttpClientBuilder.addInterceptor((Interceptor)new AuthorizationInterceptor(apiKey));
        if (logRequests.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new RequestLoggingInterceptor());
        }
        if (logResponses.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new ResponseLoggingInterceptor());
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)baseUrl)).client(okHttpClientBuilder.build()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)VoyageAiJsonUtils.getObjectMapper())).build();
        this.voyageAiApi = (VoyageAiApi)retrofit.create(VoyageAiApi.class);
    }

    EmbeddingResponse embed(EmbeddingRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.voyageAiApi.embed(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (EmbeddingResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    RerankResponse rerank(RerankRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.voyageAiApi.rerank(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (RerankResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RuntimeException toException(retrofit2.Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    static Builder builder() {
        return new Builder();
    }

    static class AuthorizationInterceptor
    implements Interceptor {
        private final String apiKey;

        AuthorizationInterceptor(String apiKey) {
            this.apiKey = apiKey;
        }

        @NotNull
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request.Builder builder = chain.request().newBuilder();
            builder.addHeader("Authorization", "Bearer " + this.apiKey);
            return chain.proceed(builder.build());
        }
    }

    static class Builder {
        private String baseUrl;
        private Duration timeout;
        private String apiKey;
        private Boolean logRequests;
        private Boolean logResponses;

        Builder() {
        }

        Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        Builder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        Builder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        VoyageAiClient build() {
            return new VoyageAiClient(this.baseUrl, this.timeout, this.apiKey, this.logRequests, this.logResponses);
        }
    }
}

