/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.voyageai;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.DimensionAwareEmbeddingModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.voyageai.EmbeddingRequest;
import dev.langchain4j.model.voyageai.EmbeddingResponse;
import dev.langchain4j.model.voyageai.VoyageAiClient;
import dev.langchain4j.model.voyageai.VoyageAiEmbeddingModelName;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class VoyageAiEmbeddingModel
extends DimensionAwareEmbeddingModel {
    private final VoyageAiClient client;
    private final Integer maxRetries;
    private final String modelName;
    private final String inputType;
    private final Boolean truncation;
    private final String encodingFormat;
    private final Integer maxSegmentsPerBatch;

    public VoyageAiEmbeddingModel(String baseUrl, Duration timeout, Integer maxRetries, String apiKey, String modelName, String inputType, Boolean truncation, String encodingFormat, Boolean logRequests, Boolean logResponses, Integer maxSegmentsPerBatch) {
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.maxSegmentsPerBatch = (Integer)Utils.getOrDefault((Object)maxSegmentsPerBatch, (Object)128);
        this.truncation = truncation;
        this.inputType = inputType;
        this.encodingFormat = encodingFormat;
        this.client = VoyageAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.voyageai.com/v1/")).apiKey(ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey")).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<String> texts = textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
        return this.embedTexts(texts);
    }

    private Response<List<Embedding>> embedTexts(List<String> texts) {
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        int inputTokenCount = 0;
        for (int i = 0; i < texts.size(); i += this.maxSegmentsPerBatch.intValue()) {
            List<String> batch = texts.subList(i, Math.min(i + this.maxSegmentsPerBatch, texts.size()));
            EmbeddingRequest request = EmbeddingRequest.builder().input(batch).inputType(this.inputType).model(this.modelName).truncation(this.truncation).encodingFormat(this.encodingFormat).build();
            EmbeddingResponse response = (EmbeddingResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.embed(request), (int)this.maxRetries);
            embeddings.addAll(this.getEmbeddings(response));
            inputTokenCount += this.getTokenUsage(response).intValue();
        }
        return Response.from(embeddings, (TokenUsage)new TokenUsage(Integer.valueOf(inputTokenCount)));
    }

    protected Integer knownDimension() {
        return VoyageAiEmbeddingModelName.knownDimension(this.modelName);
    }

    private List<Embedding> getEmbeddings(EmbeddingResponse response) {
        return response.getData().stream().sorted(Comparator.comparingInt(EmbeddingResponse.EmbeddingData::getIndex)).map(EmbeddingResponse.EmbeddingData::getEmbedding).map(Embedding::from).collect(Collectors.toList());
    }

    private Integer getTokenUsage(EmbeddingResponse response) {
        if (response.getUsage() != null) {
            return response.getUsage().getTotalTokens();
        }
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String baseUrl;
        private Duration timeout;
        private Integer maxRetries;
        private String apiKey;
        private String modelName;
        private String inputType;
        private Boolean truncation;
        private String encodingFormat;
        private Boolean logRequests;
        private Boolean logResponses;
        private Integer maxSegmentsPerBatch;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder modelName(VoyageAiEmbeddingModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder truncation(Boolean truncation) {
            this.truncation = truncation;
            return this;
        }

        public Builder encodingFormat(String encodingFormat) {
            this.encodingFormat = encodingFormat;
            return this;
        }

        public Builder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public Builder maxSegmentsPerBatch(Integer maxSegmentsPerBatch) {
            this.maxSegmentsPerBatch = maxSegmentsPerBatch;
            return this;
        }

        public VoyageAiEmbeddingModel build() {
            return new VoyageAiEmbeddingModel(this.baseUrl, this.timeout, this.maxRetries, this.apiKey, this.modelName, this.inputType, this.truncation, this.encodingFormat, this.logRequests, this.logResponses, this.maxSegmentsPerBatch);
        }
    }
}

