/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search.tavily;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.WebSearchInformationResult;
import dev.langchain4j.web.search.WebSearchOrganicResult;
import dev.langchain4j.web.search.WebSearchRequest;
import dev.langchain4j.web.search.WebSearchResults;
import dev.langchain4j.web.search.tavily.TavilyClient;
import dev.langchain4j.web.search.tavily.TavilyResponse;
import dev.langchain4j.web.search.tavily.TavilySearchRequest;
import dev.langchain4j.web.search.tavily.TavilySearchResult;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TavilyWebSearchEngine
implements WebSearchEngine {
    private static final String DEFAULT_BASE_URL = "https://api.tavily.com/";
    private final String apiKey;
    private final TavilyClient tavilyClient;
    private final String searchDepth;
    private final Boolean includeAnswer;
    private final Boolean includeRawContent;
    private final List<String> includeDomains;
    private final List<String> excludeDomains;

    public TavilyWebSearchEngine(String baseUrl, String apiKey, Duration timeout, String searchDepth, Boolean includeAnswer, Boolean includeRawContent, List<String> includeDomains, List<String> excludeDomains) {
        this.tavilyClient = TavilyClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)DEFAULT_BASE_URL)).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(10L))).build();
        this.apiKey = ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey");
        this.searchDepth = searchDepth;
        this.includeAnswer = includeAnswer;
        this.includeRawContent = includeRawContent;
        this.includeDomains = Utils.copyIfNotNull(includeDomains);
        this.excludeDomains = Utils.copyIfNotNull(excludeDomains);
    }

    public WebSearchResults search(WebSearchRequest webSearchRequest) {
        TavilySearchRequest request = TavilySearchRequest.builder().apiKey(this.apiKey).query(webSearchRequest.searchTerms()).searchDepth(this.searchDepth).includeAnswer(this.includeAnswer).includeRawContent(this.includeRawContent).maxResults(webSearchRequest.maxResults()).includeDomains(this.includeDomains).excludeDomains(this.excludeDomains).build();
        TavilyResponse tavilyResponse = this.tavilyClient.search(request);
        List results = tavilyResponse.getResults().stream().map(TavilyWebSearchEngine::toWebSearchOrganicResult).collect(Collectors.toList());
        if (tavilyResponse.getAnswer() != null) {
            WebSearchOrganicResult answerResult = WebSearchOrganicResult.from((String)"Tavily Search API", (URI)URI.create("https://tavily.com/"), (String)tavilyResponse.getAnswer(), null);
            results.add(0, answerResult);
        }
        return WebSearchResults.from((WebSearchInformationResult)WebSearchInformationResult.from((Long)Long.valueOf(results.size())), results);
    }

    public static TavilyWebSearchEngine withApiKey(String apiKey) {
        return TavilyWebSearchEngine.builder().apiKey(apiKey).build();
    }

    private static WebSearchOrganicResult toWebSearchOrganicResult(TavilySearchResult tavilySearchResult) {
        String safeUrlEncoded = URLEncoder.encode(tavilySearchResult.getUrl(), StandardCharsets.UTF_8).replace("+", "%20");
        return WebSearchOrganicResult.from((String)tavilySearchResult.getTitle(), (URI)URI.create(safeUrlEncoded), (String)tavilySearchResult.getContent(), (String)tavilySearchResult.getRawContent(), Collections.singletonMap("score", String.valueOf(tavilySearchResult.getScore())));
    }

    public static TavilyWebSearchEngineBuilder builder() {
        return new TavilyWebSearchEngineBuilder();
    }

    public static class TavilyWebSearchEngineBuilder {
        private String baseUrl;
        private String apiKey;
        private Duration timeout;
        private String searchDepth;
        private Boolean includeAnswer;
        private Boolean includeRawContent;
        private List<String> includeDomains;
        private List<String> excludeDomains;

        TavilyWebSearchEngineBuilder() {
        }

        public TavilyWebSearchEngineBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public TavilyWebSearchEngineBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public TavilyWebSearchEngineBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public TavilyWebSearchEngineBuilder searchDepth(String searchDepth) {
            this.searchDepth = searchDepth;
            return this;
        }

        public TavilyWebSearchEngineBuilder includeAnswer(Boolean includeAnswer) {
            this.includeAnswer = includeAnswer;
            return this;
        }

        public TavilyWebSearchEngineBuilder includeRawContent(Boolean includeRawContent) {
            this.includeRawContent = includeRawContent;
            return this;
        }

        public TavilyWebSearchEngineBuilder includeDomains(List<String> includeDomains) {
            this.includeDomains = includeDomains;
            return this;
        }

        public TavilyWebSearchEngineBuilder excludeDomains(List<String> excludeDomains) {
            this.excludeDomains = excludeDomains;
            return this;
        }

        public TavilyWebSearchEngine build() {
            return new TavilyWebSearchEngine(this.baseUrl, this.apiKey, this.timeout, this.searchDepth, this.includeAnswer, this.includeRawContent, this.includeDomains, this.excludeDomains);
        }

        public String toString() {
            return "TavilyWebSearchEngine.TavilyWebSearchEngineBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", timeout=" + String.valueOf(this.timeout) + ", searchDepth=" + this.searchDepth + ", includeAnswer=" + this.includeAnswer + ", includeRawContent=" + this.includeRawContent + ", includeDomains=" + String.valueOf(this.includeDomains) + ", excludeDomains=" + String.valueOf(this.excludeDomains) + ")";
        }
    }
}

