/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search.tavily;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.web.search.tavily.TavilyApi;
import dev.langchain4j.web.search.tavily.TavilyResponse;
import dev.langchain4j.web.search.tavily.TavilySearchRequest;
import java.io.IOException;
import java.time.Duration;
import lombok.Generated;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

class TavilyClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).enable(SerializationFeature.INDENT_OUTPUT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final TavilyApi tavilyApi;

    public TavilyClient(String baseUrl, Duration timeout) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)baseUrl)).client(okHttpClientBuilder.build()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)OBJECT_MAPPER)).build();
        this.tavilyApi = (TavilyApi)retrofit.create(TavilyApi.class);
    }

    public TavilyResponse search(TavilySearchRequest searchRequest) {
        try {
            Response retrofitResponse = this.tavilyApi.search(searchRequest).execute();
            if (retrofitResponse.isSuccessful()) {
                return (TavilyResponse)retrofitResponse.body();
            }
            throw TavilyClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    @Generated
    public static TavilyClientBuilder builder() {
        return new TavilyClientBuilder();
    }

    @Generated
    public static class TavilyClientBuilder {
        @Generated
        private String baseUrl;
        @Generated
        private Duration timeout;

        @Generated
        TavilyClientBuilder() {
        }

        @Generated
        public TavilyClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public TavilyClientBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public TavilyClient build() {
            return new TavilyClient(this.baseUrl, this.timeout);
        }

        @Generated
        public String toString() {
            return "TavilyClient.TavilyClientBuilder(baseUrl=" + this.baseUrl + ", timeout=" + String.valueOf(this.timeout) + ")";
        }
    }
}

