/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.zhipu.DefaultZhipuAiHelper;
import dev.langchain4j.model.zhipu.ZhipuAiClient;
import dev.langchain4j.model.zhipu.embedding.EmbeddingModel;
import dev.langchain4j.model.zhipu.embedding.EmbeddingRequest;
import dev.langchain4j.model.zhipu.embedding.EmbeddingResponse;
import dev.langchain4j.model.zhipu.shared.Usage;
import dev.langchain4j.model.zhipu.spi.ZhipuAiEmbeddingModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ZhipuAiEmbeddingModel
implements dev.langchain4j.model.embedding.EmbeddingModel {
    private final String baseUrl;
    private final Integer maxRetries;
    private final String model;
    private final ZhipuAiClient client;

    public ZhipuAiEmbeddingModel(String baseUrl, String apiKey, String model, Integer maxRetries, Boolean logRequests, Boolean logResponses) {
        this.baseUrl = (String)Utils.getOrDefault((Object)baseUrl, (Object)"https://open.bigmodel.cn/");
        this.model = (String)Utils.getOrDefault((Object)model, (Object)EmbeddingModel.EMBEDDING_2.toString());
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.client = ZhipuAiClient.builder().baseUrl(this.baseUrl).apiKey(apiKey).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
    }

    public static ZhipuAiEmbeddingModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(ZhipuAiEmbeddingModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            ZhipuAiEmbeddingModelBuilderFactory factories = (ZhipuAiEmbeddingModelBuilderFactory)iterator.next();
            return (ZhipuAiEmbeddingModelBuilder)factories.get();
        }
        return new ZhipuAiEmbeddingModelBuilder();
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<EmbeddingResponse> embeddingRequests = textSegments.stream().map(item -> EmbeddingRequest.builder().input(item.text()).model(this.model).build()).map(request -> (EmbeddingResponse)RetryUtils.withRetry(() -> this.client.embedAll((EmbeddingRequest)request), (int)this.maxRetries)).collect(Collectors.toList());
        Usage usage = DefaultZhipuAiHelper.getEmbeddingUsage(embeddingRequests);
        return Response.from(DefaultZhipuAiHelper.toEmbed(embeddingRequests), (TokenUsage)DefaultZhipuAiHelper.tokenUsageFrom(usage));
    }

    public static class ZhipuAiEmbeddingModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String model;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;

        public ZhipuAiEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public ZhipuAiEmbeddingModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ZhipuAiEmbeddingModelBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ZhipuAiEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public ZhipuAiEmbeddingModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public ZhipuAiEmbeddingModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public ZhipuAiEmbeddingModel build() {
            return new ZhipuAiEmbeddingModel(this.baseUrl, this.apiKey, this.model, this.maxRetries, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "ZhipuAiEmbeddingModel.ZhipuAiEmbeddingModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", model=" + this.model + ", maxRetries=" + this.maxRetries + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

