/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.zhipu.DefaultZhipuAiHelper;
import dev.langchain4j.model.zhipu.ZhipuAiClient;
import dev.langchain4j.model.zhipu.chat.ChatCompletionModel;
import dev.langchain4j.model.zhipu.chat.ChatCompletionRequest;
import dev.langchain4j.model.zhipu.chat.ToolChoiceMode;
import dev.langchain4j.model.zhipu.spi.ZhipuAiStreamingChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ZhipuAiStreamingChatModel
implements StreamingChatLanguageModel {
    private final String baseUrl;
    private final Double temperature;
    private final Double topP;
    private final String model;
    private final Integer maxToken;
    private final ZhipuAiClient client;

    public ZhipuAiStreamingChatModel(String baseUrl, String apiKey, Double temperature, Double topP, String model, Integer maxToken, Boolean logRequests, Boolean logResponses) {
        this.baseUrl = (String)Utils.getOrDefault((Object)baseUrl, (Object)"https://open.bigmodel.cn/");
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.topP = topP;
        this.model = (String)Utils.getOrDefault((Object)model, (Object)ChatCompletionModel.GLM_4.toString());
        this.maxToken = (Integer)Utils.getOrDefault((Object)maxToken, (Object)512);
        this.client = ZhipuAiClient.builder().baseUrl(this.baseUrl).apiKey(apiKey).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
    }

    public static ZhipuAiStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(ZhipuAiStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            ZhipuAiStreamingChatModelBuilderFactory factories = (ZhipuAiStreamingChatModelBuilderFactory)iterator.next();
            return (ZhipuAiStreamingChatModelBuilder)factories.get();
        }
        return new ZhipuAiStreamingChatModelBuilder();
    }

    public void generate(String userMessage, StreamingResponseHandler<AiMessage> handler) {
        this.generate(Collections.singletonList(UserMessage.from((String)userMessage)), handler);
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, (ToolSpecification)null, handler);
    }

    public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        ChatCompletionRequest.Builder builder = ChatCompletionRequest.builder().model(this.model).maxTokens(this.maxToken).stream(true).topP(this.topP).temperature(this.temperature).toolChoice(ToolChoiceMode.AUTO).messages(DefaultZhipuAiHelper.toZhipuAiMessages(messages));
        if (!Utils.isNullOrEmpty(toolSpecifications)) {
            builder.tools(DefaultZhipuAiHelper.toTools(toolSpecifications));
        }
        this.client.streamingChatCompletion(builder.build(), handler);
    }

    public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, toolSpecification == null ? null : Collections.singletonList(toolSpecification), handler);
    }

    public static class ZhipuAiStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private Double temperature;
        private Double topP;
        private String model;
        private Integer maxToken;
        private Boolean logRequests;
        private Boolean logResponses;

        public ZhipuAiStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder maxToken(Integer maxToken) {
            this.maxToken = maxToken;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public ZhipuAiStreamingChatModel build() {
            return new ZhipuAiStreamingChatModel(this.baseUrl, this.apiKey, this.temperature, this.topP, this.model, this.maxToken, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "ZhipuAiStreamingChatModel.ZhipuAiStreamingChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", temperature=" + this.temperature + ", topP=" + this.topP + ", model=" + this.model + ", maxToken=" + this.maxToken + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

