/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu.chat;

import com.google.gson.annotations.SerializedName;
import dev.langchain4j.model.zhipu.chat.Message;
import dev.langchain4j.model.zhipu.chat.Role;
import dev.langchain4j.model.zhipu.chat.ToolCall;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class AssistantMessage
implements Message {
    private final Role role = Role.ASSISTANT;
    private final String content;
    private final String name;
    @SerializedName(value="tool_calls")
    private final List<ToolCall> toolCalls;

    private AssistantMessage(Builder builder) {
        this.content = builder.content;
        this.name = builder.name;
        this.toolCalls = builder.toolCalls;
    }

    public static AssistantMessage from(String content) {
        return AssistantMessage.builder().content(content).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    public String toString() {
        return "AssistantMessage(role=" + (Object)((Object)this.getRole()) + ", content=" + this.getContent() + ", name=" + this.getName() + ", toolCalls=" + this.getToolCalls() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssistantMessage)) {
            return false;
        }
        AssistantMessage other = (AssistantMessage)o;
        Role this$role = this.getRole();
        Role other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ToolCall> this$toolCalls = this.getToolCalls();
        List<ToolCall> other$toolCalls = other.getToolCalls();
        return !(this$toolCalls == null ? other$toolCalls != null : !((Object)this$toolCalls).equals(other$toolCalls));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Role $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ToolCall> $toolCalls = this.getToolCalls();
        result = result * 59 + ($toolCalls == null ? 43 : ((Object)$toolCalls).hashCode());
        return result;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public static final class Builder {
        private String content;
        private String name;
        private List<ToolCall> toolCalls;

        private Builder() {
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder toolCalls(ToolCall ... toolCalls) {
            return this.toolCalls(Arrays.asList(toolCalls));
        }

        public Builder toolCalls(List<ToolCall> toolCalls) {
            if (toolCalls != null) {
                this.toolCalls = Collections.unmodifiableList(toolCalls);
            }
            return this;
        }

        public AssistantMessage build() {
            return new AssistantMessage(this);
        }
    }
}

