/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu.embedding;

import dev.langchain4j.model.zhipu.embedding.Embedding;
import dev.langchain4j.model.zhipu.shared.Usage;
import java.util.Collections;
import java.util.List;

public final class EmbeddingResponse {
    private final String model;
    private final String object;
    private final List<Embedding> data;
    private final Usage usage;

    private EmbeddingResponse(Builder builder) {
        this.model = builder.model;
        this.object = builder.object;
        this.data = builder.data;
        this.usage = builder.usage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Float> getEmbedding() {
        return this.data.get(0).getEmbedding();
    }

    public String getModel() {
        return this.model;
    }

    public String getObject() {
        return this.object;
    }

    public List<Embedding> getData() {
        return this.data;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public String toString() {
        return "EmbeddingResponse(model=" + this.getModel() + ", object=" + this.getObject() + ", data=" + this.getData() + ", usage=" + this.getUsage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingResponse)) {
            return false;
        }
        EmbeddingResponse other = (EmbeddingResponse)o;
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<Embedding> this$data = this.getData();
        List<Embedding> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Usage this$usage = this.getUsage();
        Usage other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<Embedding> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Usage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }

    public static final class Builder {
        private String model;
        private String object;
        private List<Embedding> data;
        private Usage usage;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder object(String object) {
            this.object = object;
            return this;
        }

        public Builder data(List<Embedding> data) {
            if (data != null) {
                this.data = Collections.unmodifiableList(data);
            }
            return this;
        }

        public Builder usage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public EmbeddingResponse build() {
            return new EmbeddingResponse(this);
        }
    }
}

