/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu.shared;

import com.google.gson.annotations.SerializedName;

public final class Usage {
    @SerializedName(value="prompt_tokens")
    private Integer promptTokens;
    @SerializedName(value="completion_tokens")
    private Integer completionTokens;
    @SerializedName(value="total_tokens")
    private Integer totalTokens;

    private Usage(Builder builder) {
        this.promptTokens = builder.promptTokens;
        this.completionTokens = builder.completionTokens;
        this.totalTokens = builder.totalTokens;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void add(Usage usage) {
        this.promptTokens = this.promptTokens + usage.promptTokens;
        this.completionTokens = this.completionTokens + usage.completionTokens;
        this.totalTokens = this.totalTokens + usage.totalTokens;
    }

    public Integer getPromptTokens() {
        return this.promptTokens;
    }

    public Integer getCompletionTokens() {
        return this.completionTokens;
    }

    public Integer getTotalTokens() {
        return this.totalTokens;
    }

    public String toString() {
        return "Usage(promptTokens=" + this.getPromptTokens() + ", completionTokens=" + this.getCompletionTokens() + ", totalTokens=" + this.getTotalTokens() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Usage)) {
            return false;
        }
        Usage other = (Usage)o;
        Integer this$promptTokens = this.getPromptTokens();
        Integer other$promptTokens = other.getPromptTokens();
        if (this$promptTokens == null ? other$promptTokens != null : !((Object)this$promptTokens).equals(other$promptTokens)) {
            return false;
        }
        Integer this$completionTokens = this.getCompletionTokens();
        Integer other$completionTokens = other.getCompletionTokens();
        if (this$completionTokens == null ? other$completionTokens != null : !((Object)this$completionTokens).equals(other$completionTokens)) {
            return false;
        }
        Integer this$totalTokens = this.getTotalTokens();
        Integer other$totalTokens = other.getTotalTokens();
        return !(this$totalTokens == null ? other$totalTokens != null : !((Object)this$totalTokens).equals(other$totalTokens));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $promptTokens = this.getPromptTokens();
        result = result * 59 + ($promptTokens == null ? 43 : ((Object)$promptTokens).hashCode());
        Integer $completionTokens = this.getCompletionTokens();
        result = result * 59 + ($completionTokens == null ? 43 : ((Object)$completionTokens).hashCode());
        Integer $totalTokens = this.getTotalTokens();
        result = result * 59 + ($totalTokens == null ? 43 : ((Object)$totalTokens).hashCode());
        return result;
    }

    public static final class Builder {
        private Integer promptTokens;
        private Integer completionTokens;
        private Integer totalTokens;

        private Builder() {
        }

        public Builder promptTokens(Integer promptTokens) {
            this.promptTokens = promptTokens;
            return this;
        }

        public Builder completionTokens(Integer completionTokens) {
            this.completionTokens = completionTokens;
            return this;
        }

        public Builder totalTokens(Integer totalTokens) {
            this.totalTokens = totalTokens;
            return this;
        }

        public Usage build() {
            return new Usage(this);
        }
    }
}

