/*
 * Decompiled with CFR 0.152.
 */
package dev.likemagic.bluebreeze;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import androidx.annotation.RequiresApi;
import dev.likemagic.bluebreeze.BBCharacteristic;
import dev.likemagic.bluebreeze.BBConstants;
import dev.likemagic.bluebreeze.BBDeviceConnectionStatus;
import dev.likemagic.bluebreeze.BBDeviceKt;
import dev.likemagic.bluebreeze.BBOperation;
import dev.likemagic.bluebreeze.BBOperationQueue;
import dev.likemagic.bluebreeze.BBService;
import dev.likemagic.bluebreeze.operations.BBOperationConnect;
import dev.likemagic.bluebreeze.operations.BBOperationDisconnect;
import dev.likemagic.bluebreeze.operations.BBOperationDiscoverServices;
import dev.likemagic.bluebreeze.operations.BBOperationRequestMtu;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010E\u001a\u00020FH\u0086@\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\u00020FH\u0086@\u00a2\u0006\u0002\u0010GJ\u000e\u0010I\u001a\u00020FH\u0086@\u00a2\u0006\u0002\u0010GJ\u0016\u0010J\u001a\u00020\u00162\u0006\u0010C\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010KJ\"\u0010P\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u0002HQ0NH\u0096@\u00a2\u0006\u0002\u0010SJ\b\u0010T\u001a\u00020FH\u0002J\"\u0010U\u001a\u00020F2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010V\u001a\u00020\u00162\u0006\u0010W\u001a\u00020\u0016H\u0016J\u001a\u0010X\u001a\u00020F2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010V\u001a\u00020\u0016H\u0016J\"\u0010Y\u001a\u00020F2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010C\u001a\u00020\u00162\u0006\u0010V\u001a\u00020\u0016H\u0016J$\u0010Z\u001a\u00020F2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010[\u001a\u0004\u0018\u00010\\2\u0006\u0010V\u001a\u00020\u0016H\u0016J$\u0010]\u001a\u00020F2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010^\u001a\u0004\u0018\u00010_2\u0006\u0010V\u001a\u00020\u0016H\u0017J(\u0010]\u001a\u00020F2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020\u001e2\u0006\u0010V\u001a\u00020\u0016H\u0017J$\u0010a\u001a\u00020F2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010^\u001a\u0004\u0018\u00010_2\u0006\u0010V\u001a\u00020\u0016H\u0016J\u001c\u0010b\u001a\u00020F2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010^\u001a\u0004\u0018\u00010_H\u0017J \u0010b\u001a\u00020F2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020\u001eH\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR&\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R \u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010,\"\u0004\b-\u0010.R\u0013\u0010/\u001a\u0004\u0018\u00010\u001e8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0013\u00102\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0013\u00105\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0012R\u001a\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002090$08X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002090$0;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020?08X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020?0;8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010=R\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001608X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00160;8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010=R\u0018\u0010L\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030N0MX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010O\u001a\b\u0012\u0002\b\u0003\u0018\u00010NX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Ldev/likemagic/bluebreeze/BBDevice;", "Landroid/bluetooth/BluetoothGattCallback;", "Ldev/likemagic/bluebreeze/BBOperationQueue;", "context", "Landroid/content/Context;", "device", "Landroid/bluetooth/BluetoothDevice;", "<init>", "(Landroid/content/Context;Landroid/bluetooth/BluetoothDevice;)V", "getContext", "()Landroid/content/Context;", "getDevice", "()Landroid/bluetooth/BluetoothDevice;", "gatt", "Landroid/bluetooth/BluetoothGatt;", "address", "", "getAddress", "()Ljava/lang/String;", "name", "getName", "rssi", "", "getRssi", "()I", "setRssi", "(I)V", "advertisementData", "", "Lkotlin/UByte;", "", "getAdvertisementData", "()Ljava/util/Map;", "setAdvertisementData", "(Ljava/util/Map;)V", "advertisedServices", "", "LBBUUID;", "getAdvertisedServices", "()Ljava/util/List;", "setAdvertisedServices", "(Ljava/util/List;)V", "isConnectable", "", "()Z", "setConnectable", "(Z)V", "manufacturerData", "getManufacturerData", "()[B", "manufacturerId", "getManufacturerId", "()Ljava/lang/Integer;", "manufacturerName", "getManufacturerName", "_services", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Ldev/likemagic/bluebreeze/BBService;", "services", "Lkotlinx/coroutines/flow/StateFlow;", "getServices", "()Lkotlinx/coroutines/flow/StateFlow;", "_connectionStatus", "Ldev/likemagic/bluebreeze/BBDeviceConnectionStatus;", "connectionStatus", "getConnectionStatus", "_mtu", "mtu", "getMtu", "connect", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disconnect", "discoverServices", "requestMTU", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "operationQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ldev/likemagic/bluebreeze/BBOperation;", "operationCurrent", "operationEnqueue", "T", "operation", "(Ldev/likemagic/bluebreeze/BBOperation;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "operationCheck", "onConnectionStateChange", "status", "newState", "onServicesDiscovered", "onMtuChanged", "onDescriptorWrite", "descriptor", "Landroid/bluetooth/BluetoothGattDescriptor;", "onCharacteristicRead", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "value", "onCharacteristicWrite", "onCharacteristicChanged", "bluebreeze_release"})
@SourceDebugExtension(value={"SMAP\nBBDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BBDevice.kt\ndev/likemagic/bluebreeze/BBDevice\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n1863#2:322\n1863#2,2:323\n1864#2:325\n1557#2:326\n1628#2,2:327\n1557#2:329\n1628#2,3:330\n1630#2:333\n*S KotlinDebug\n*F\n+ 1 BBDevice.kt\ndev/likemagic/bluebreeze/BBDevice\n*L\n166#1:322\n167#1:323,2\n166#1:325\n196#1:326\n196#1:327,2\n199#1:329\n199#1:330,3\n196#1:333\n*E\n"})
public final class BBDevice
extends BluetoothGattCallback
implements BBOperationQueue {
    @NotNull
    private final Context context;
    @NotNull
    private final BluetoothDevice device;
    @Nullable
    private BluetoothGatt gatt;
    private int rssi;
    @NotNull
    private Map<UByte, byte[]> advertisementData;
    @NotNull
    private List<BBUUID> advertisedServices;
    private boolean isConnectable;
    @NotNull
    private final MutableStateFlow<List<BBService>> _services;
    @NotNull
    private final MutableStateFlow<BBDeviceConnectionStatus> _connectionStatus;
    @NotNull
    private final MutableStateFlow<Integer> _mtu;
    @NotNull
    private final LinkedBlockingQueue<BBOperation<?>> operationQueue;
    @Nullable
    private BBOperation<?> operationCurrent;

    public BBDevice(@NotNull Context context, @NotNull BluetoothDevice device) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        this.context = context;
        this.device = device;
        this.advertisementData = MapsKt.emptyMap();
        this.advertisedServices = CollectionsKt.emptyList();
        this._services = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this._connectionStatus = StateFlowKt.MutableStateFlow((Object)((Object)BBDeviceConnectionStatus.disconnected));
        this._mtu = StateFlowKt.MutableStateFlow((Object)23);
        this.operationQueue = new LinkedBlockingQueue();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final BluetoothDevice getDevice() {
        return this.device;
    }

    @NotNull
    public final String getAddress() {
        String string = this.device.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAddress(...)");
        return string;
    }

    @Nullable
    public final String getName() {
        String string = this.device.getName();
        if (string == null) {
            String string2;
            Object object;
            byte[] byArray = this.advertisementData.get(UByte.box-impl((byte)9));
            if (byArray != null) {
                byte[] byArray2 = byArray;
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
                object = charset;
                string2 = new String(byArray2, (Charset)object);
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                String string3;
                Charset charset;
                byte[] byArray3 = this.advertisementData.get(UByte.box-impl((byte)8));
                if (byArray3 != null) {
                    object = byArray3;
                    Charset charset2 = Charset.defaultCharset();
                    Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"defaultCharset(...)");
                    charset = charset2;
                    string3 = new String((byte[])object, charset);
                } else {
                    string3 = string = null;
                }
                if (string3 == null) {
                    byte[] byArray4 = this.advertisementData.get(UByte.box-impl((byte)48));
                    if (byArray4 != null) {
                        object = byArray4;
                        Charset charset3 = Charset.defaultCharset();
                        Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"defaultCharset(...)");
                        charset = charset3;
                        string = new String((byte[])object, charset);
                    } else {
                        string = null;
                    }
                }
            }
        }
        return string;
    }

    public final int getRssi() {
        return this.rssi;
    }

    public final void setRssi(int n) {
        this.rssi = n;
    }

    @NotNull
    public final Map<UByte, byte[]> getAdvertisementData() {
        return this.advertisementData;
    }

    public final void setAdvertisementData(@NotNull Map<UByte, byte[]> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.advertisementData = map;
    }

    @NotNull
    public final List<BBUUID> getAdvertisedServices() {
        return this.advertisedServices;
    }

    public final void setAdvertisedServices(@NotNull List<BBUUID> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.advertisedServices = list;
    }

    public final boolean isConnectable() {
        return this.isConnectable;
    }

    public final void setConnectable(boolean bl) {
        this.isConnectable = bl;
    }

    @Nullable
    public final byte[] getManufacturerData() {
        return this.advertisementData.get(UByte.box-impl((byte)-1));
    }

    @Nullable
    public final Integer getManufacturerId() {
        byte[] byArray = this.getManufacturerData();
        if (byArray == null) {
            return null;
        }
        byte[] manufacturerData = byArray;
        return (UByte.constructor-impl((byte)manufacturerData[1]) & 0xFF) << 8 | UByte.constructor-impl((byte)manufacturerData[0]) & 0xFF;
    }

    @Nullable
    public final String getManufacturerName() {
        Integer n = this.getManufacturerId();
        if (n == null) {
            return null;
        }
        int manufacturerId = n;
        return BBConstants.Manufacturer.INSTANCE.getKnownIds().get(manufacturerId);
    }

    @NotNull
    public final StateFlow<List<BBService>> getServices() {
        return (StateFlow)this._services;
    }

    @NotNull
    public final StateFlow<BBDeviceConnectionStatus> getConnectionStatus() {
        return (StateFlow)this._connectionStatus;
    }

    @NotNull
    public final StateFlow<Integer> getMtu() {
        return (StateFlow)this._mtu;
    }

    @Nullable
    public final Object connect(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.operationEnqueue(new BBOperationConnect(this), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object disconnect(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.operationEnqueue(new BBOperationDisconnect(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object discoverServices(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.operationEnqueue(new BBOperationDiscoverServices(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object requestMTU(int mtu, @NotNull Continuation<? super Integer> $completion) {
        return this.operationEnqueue(new BBOperationRequestMtu(mtu), $completion);
    }

    @Override
    @Nullable
    public <T> Object operationEnqueue(@NotNull BBOperation<T> operation, @NotNull Continuation<? super T> $completion) {
        Continuation<? super T> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        operation.setContinuation(continuation2);
        this.operationQueue.add(operation);
        this.operationCheck();
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final void operationCheck() {
        block1: {
            BBOperation<?> bBOperation = this.operationCurrent;
            boolean bl = bBOperation != null ? !bBOperation.isComplete() : false;
            if (bl) {
                return;
            }
            this.operationCurrent = this.operationQueue.poll();
            BBOperation<?> bBOperation2 = this.operationCurrent;
            if (bBOperation2 == null) break block1;
            BBOperation<?> operation = bBOperation2;
            boolean bl2 = false;
            operation.execute(this.context, this.device, this.gatt);
            Timer timer = new Timer();
            long l = (long)(operation.getTimeout() * (float)1000);
            TimerTask timerTask = new TimerTask(operation){
                final /* synthetic */ BBOperation $operation$inlined;
                {
                    this.$operation$inlined = bBOperation;
                }

                public void run() {
                    TimerTask $this$operationCheck_u24lambda_u242_u24lambda_u241 = this;
                    boolean bl = false;
                    if (!this.$operation$inlined.isComplete()) {
                        this.$operation$inlined.cancel();
                    }
                }
            };
            timer.schedule(timerTask, l);
        }
    }

    public void onConnectionStateChange(@Nullable BluetoothGatt gatt, int status, int newState) {
        if (gatt == null) {
            return;
        }
        Iterable $this$forEach$iv = (Iterable)this.getServices().getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BBService service = (BBService)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = service.getCharacteristics();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BBCharacteristic characteristic = (BBCharacteristic)((Object)element$iv2);
                boolean bl2 = false;
                characteristic.onConnectionStateChange(gatt, status, newState);
            }
        }
        BBOperation<?> bBOperation = this.operationCurrent;
        if (bBOperation != null) {
            bBOperation.onConnectionStateChange(gatt, status, newState);
        }
        switch (newState) {
            case 2: {
                this.gatt = gatt;
                this._connectionStatus.setValue((Object)BBDeviceConnectionStatus.connected);
                break;
            }
            case 0: {
                this._connectionStatus.setValue((Object)BBDeviceConnectionStatus.disconnected);
                this._mtu.setValue((Object)23);
                this._services.setValue((Object)CollectionsKt.emptyList());
            }
        }
        this.operationCheck();
    }

    /*
     * WARNING - void declaration
     */
    public void onServicesDiscovered(@Nullable BluetoothGatt gatt, int status) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (gatt == null) {
            return;
        }
        List list = gatt.getServices();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getServices(...)");
        Iterable iterable = list;
        MutableStateFlow<List<BBService>> mutableStateFlow = this._services;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            BluetoothGattService bluetoothGattService = (BluetoothGattService)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UUID uUID = it.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
            BBUUID bBUUID = new BBUUID(uUID);
            List list2 = it.getCharacteristics();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCharacteristics(...)");
            Iterable iterable2 = list2;
            BBUUID bBUUID2 = bBUUID;
            boolean $i$f$map2 = false;
            void var15_16 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it2;
                BluetoothGattCharacteristic bluetoothGattCharacteristic = (BluetoothGattCharacteristic)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it2);
                collection2.add(new BBCharacteristic((BluetoothGattCharacteristic)it2, this));
            }
            List list3 = (List)destination$iv$iv2;
            BBUUID bBUUID3 = bBUUID2;
            collection.add(new BBService(bBUUID3, list3));
        }
        mutableStateFlow.setValue((Object)((List)destination$iv$iv));
        BBOperation<?> bBOperation = this.operationCurrent;
        if (bBOperation != null) {
            bBOperation.onServicesDiscovered(gatt, status);
        }
        this.operationCheck();
    }

    public void onMtuChanged(@Nullable BluetoothGatt gatt, int mtu, int status) {
        if (gatt == null) {
            return;
        }
        BBOperation<?> bBOperation = this.operationCurrent;
        if (bBOperation != null) {
            bBOperation.onMtuChanged(gatt, mtu, status);
        }
        this.operationCheck();
    }

    public void onDescriptorWrite(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattDescriptor descriptor, int status) {
        if (gatt == null) {
            return;
        }
        if (descriptor == null) {
            return;
        }
        UUID uUID = descriptor.getCharacteristic().getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        BBCharacteristic bBCharacteristic = BBDeviceKt.characteristic(this, uUID);
        if (bBCharacteristic != null) {
            bBCharacteristic.onDescriptorWrite(gatt, descriptor, status);
        }
        BBOperation<?> bBOperation = this.operationCurrent;
        if (bBOperation != null) {
            bBOperation.onDescriptorWrite(gatt, descriptor, status);
        }
        this.operationCheck();
    }

    @Deprecated(message="Deprecated in Java")
    public void onCharacteristicRead(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattCharacteristic characteristic, int status) {
        if (gatt == null) {
            return;
        }
        if (characteristic == null) {
            return;
        }
        UUID uUID = characteristic.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        BBCharacteristic bBCharacteristic = BBDeviceKt.characteristic(this, uUID);
        if (bBCharacteristic != null) {
            bBCharacteristic.onCharacteristicRead(gatt, characteristic, status);
        }
        BBOperation<?> bBOperation = this.operationCurrent;
        if (bBOperation != null) {
            bBOperation.onCharacteristicRead(gatt, characteristic, status);
        }
        this.operationCheck();
    }

    @RequiresApi(value=33)
    public void onCharacteristicRead(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] value, int status) {
        Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
        Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        UUID uUID = characteristic.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        BBCharacteristic bBCharacteristic = BBDeviceKt.characteristic(this, uUID);
        if (bBCharacteristic != null) {
            bBCharacteristic.onCharacteristicRead(gatt, characteristic, value, status);
        }
        BBOperation<?> bBOperation = this.operationCurrent;
        if (bBOperation != null) {
            bBOperation.onCharacteristicRead(gatt, characteristic, value, status);
        }
        this.operationCheck();
    }

    public void onCharacteristicWrite(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattCharacteristic characteristic, int status) {
        if (gatt == null) {
            return;
        }
        if (characteristic == null) {
            return;
        }
        UUID uUID = characteristic.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        BBCharacteristic bBCharacteristic = BBDeviceKt.characteristic(this, uUID);
        if (bBCharacteristic != null) {
            bBCharacteristic.onCharacteristicWrite(gatt, characteristic, status);
        }
        BBOperation<?> bBOperation = this.operationCurrent;
        if (bBOperation != null) {
            bBOperation.onCharacteristicWrite(gatt, characteristic, status);
        }
        this.operationCheck();
    }

    @Deprecated(message="Deprecated in Java")
    public void onCharacteristicChanged(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattCharacteristic characteristic) {
        if (gatt == null) {
            return;
        }
        if (characteristic == null) {
            return;
        }
        UUID uUID = characteristic.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        BBCharacteristic bBCharacteristic = BBDeviceKt.characteristic(this, uUID);
        if (bBCharacteristic != null) {
            bBCharacteristic.onCharacteristicChanged(gatt, characteristic);
        }
        BBOperation<?> bBOperation = this.operationCurrent;
        if (bBOperation != null) {
            bBOperation.onCharacteristicChanged(gatt, characteristic);
        }
        this.operationCheck();
    }

    @RequiresApi(value=33)
    public void onCharacteristicChanged(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
        Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        UUID uUID = characteristic.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        BBCharacteristic bBCharacteristic = BBDeviceKt.characteristic(this, uUID);
        if (bBCharacteristic != null) {
            bBCharacteristic.onCharacteristicChanged(gatt, characteristic, value);
        }
        BBOperation<?> bBOperation = this.operationCurrent;
        if (bBOperation != null) {
            bBOperation.onCharacteristicChanged(gatt, characteristic, value);
        }
        this.operationCheck();
    }
}

