/*
 * Decompiled with CFR 0.152.
 */
package dev.likemagic.bluebreeze;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import androidx.annotation.RequiresApi;
import dev.likemagic.bluebreeze.BBCharacteristic;
import dev.likemagic.bluebreeze.BBCharacteristicProperty;
import dev.likemagic.bluebreeze.BBConstants;
import dev.likemagic.bluebreeze.BBOperationQueue;
import dev.likemagic.bluebreeze.operations.BBOperationRead;
import dev.likemagic.bluebreeze.operations.BBOperationSubscribe;
import dev.likemagic.bluebreeze.operations.BBOperationUnsubscribe;
import dev.likemagic.bluebreeze.operations.BBOperationWrite;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010#\u001a\u00020\u001bH\u0086@\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020!H\u0086@\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020&H\u0086@\u00a2\u0006\u0002\u0010$J\u000e\u0010*\u001a\u00020&H\u0086@\u00a2\u0006\u0002\u0010$J\"\u0010+\u001a\u00020&2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0016J$\u00101\u001a\u00020&2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010.\u001a\u00020/H\u0017J(\u00101\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020/H\u0017J$\u00103\u001a\u00020&2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010.\u001a\u00020/H\u0016J\u001c\u00104\u001a\u00020&2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0017J \u00104\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u001bH\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001f\u00a8\u00065"}, d2={"Ldev/likemagic/bluebreeze/BBCharacteristic;", "Landroid/bluetooth/BluetoothGattCallback;", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "operationQueue", "Ldev/likemagic/bluebreeze/BBOperationQueue;", "<init>", "(Landroid/bluetooth/BluetoothGattCharacteristic;Ldev/likemagic/bluebreeze/BBOperationQueue;)V", "getCharacteristic", "()Landroid/bluetooth/BluetoothGattCharacteristic;", "getOperationQueue", "()Ldev/likemagic/bluebreeze/BBOperationQueue;", "uuid", "LBBUUID;", "getUuid", "()LBBUUID;", "name", "", "getName", "()Ljava/lang/String;", "properties", "", "Ldev/likemagic/bluebreeze/BBCharacteristicProperty;", "getProperties", "()Ljava/util/Set;", "_data", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "data", "Lkotlinx/coroutines/flow/StateFlow;", "getData", "()Lkotlinx/coroutines/flow/StateFlow;", "_isNotifying", "", "isNotifying", "read", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "write", "", "withResponse", "([BZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "subscribe", "unsubscribe", "onConnectionStateChange", "gatt", "Landroid/bluetooth/BluetoothGatt;", "status", "", "newState", "onCharacteristicRead", "value", "onCharacteristicWrite", "onCharacteristicChanged", "bluebreeze_release"})
public final class BBCharacteristic
extends BluetoothGattCallback {
    @NotNull
    private final BluetoothGattCharacteristic characteristic;
    @NotNull
    private final BBOperationQueue operationQueue;
    @NotNull
    private final MutableStateFlow<byte[]> _data;
    @NotNull
    private final MutableStateFlow<Boolean> _isNotifying;

    public BBCharacteristic(@NotNull BluetoothGattCharacteristic characteristic, @NotNull BBOperationQueue operationQueue) {
        Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
        Intrinsics.checkNotNullParameter((Object)operationQueue, (String)"operationQueue");
        this.characteristic = characteristic;
        this.operationQueue = operationQueue;
        this._data = StateFlowKt.MutableStateFlow((Object)new byte[0]);
        this._isNotifying = StateFlowKt.MutableStateFlow((Object)false);
    }

    @NotNull
    public final BluetoothGattCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    @NotNull
    public final BBOperationQueue getOperationQueue() {
        return this.operationQueue;
    }

    @NotNull
    public final BBUUID getUuid() {
        UUID uUID = this.characteristic.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        return new BBUUID(uUID);
    }

    @Nullable
    public final String getName() {
        return BBConstants.Characteristic.INSTANCE.getKnownUUIDs().get(this.getUuid());
    }

    @NotNull
    public final Set<BBCharacteristicProperty> getProperties() {
        Set result = new LinkedHashSet();
        if ((this.characteristic.getProperties() & 2) != 0) {
            result.add(BBCharacteristicProperty.read);
        }
        if ((this.characteristic.getProperties() & 8) != 0) {
            result.add(BBCharacteristicProperty.writeWithResponse);
        }
        if ((this.characteristic.getProperties() & 4) != 0) {
            result.add(BBCharacteristicProperty.writeWithoutResponse);
        }
        if ((this.characteristic.getProperties() & 0x10) != 0) {
            result.add(BBCharacteristicProperty.notify);
        }
        if ((this.characteristic.getProperties() & 0x20) != 0) {
            result.add(BBCharacteristicProperty.notify);
        }
        return result;
    }

    @NotNull
    public final StateFlow<byte[]> getData() {
        return (StateFlow)this._data;
    }

    @NotNull
    public final StateFlow<Boolean> isNotifying() {
        return (StateFlow)this._isNotifying;
    }

    @Nullable
    public final Object read(@NotNull Continuation<? super byte[]> $completion) {
        return this.operationQueue.operationEnqueue(new BBOperationRead(this.characteristic), $completion);
    }

    @Nullable
    public final Object write(@NotNull byte[] data, boolean withResponse, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.operationQueue.operationEnqueue(new BBOperationWrite(this.characteristic, data, withResponse), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object subscribe(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof subscribe.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BBCharacteristic this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.subscribe((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.operationQueue.operationEnqueue(new BBOperationSubscribe(this.characteristic), $continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (BBCharacteristic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                this._isNotifying.setValue((Object)Boxing.boxBoolean((boolean)true));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object unsubscribe(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof unsubscribe.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BBCharacteristic this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.unsubscribe((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.operationQueue.operationEnqueue(new BBOperationUnsubscribe(this.characteristic), $continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (BBCharacteristic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                this._isNotifying.setValue((Object)Boxing.boxBoolean((boolean)false));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void onConnectionStateChange(@Nullable BluetoothGatt gatt, int status, int newState) {
        if (gatt == null) {
            return;
        }
        if (newState == 0) {
            this._data.setValue((Object)new byte[0]);
        }
    }

    @Deprecated(message="Deprecated in Java")
    public void onCharacteristicRead(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattCharacteristic characteristic, int status) {
        if (gatt == null) {
            return;
        }
        if (characteristic == null) {
            return;
        }
        byte[] byArray = characteristic.getValue();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this._data.setValue((Object)byArray);
    }

    @RequiresApi(value=33)
    public void onCharacteristicRead(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] value, int status) {
        Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
        Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._data.setValue((Object)value);
    }

    public void onCharacteristicWrite(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattCharacteristic characteristic, int status) {
        if (gatt == null) {
            return;
        }
        if (characteristic == null) {
            return;
        }
    }

    @Deprecated(message="Deprecated in Java")
    public void onCharacteristicChanged(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattCharacteristic characteristic) {
        if (gatt == null) {
            return;
        }
        if (characteristic == null) {
            return;
        }
        byte[] byArray = characteristic.getValue();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this._data.setValue((Object)byArray);
    }

    @RequiresApi(value=33)
    public void onCharacteristicChanged(@NotNull BluetoothGatt gatt, @NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)gatt, (String)"gatt");
        Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._data.setValue((Object)value);
    }
}

