/*
 * Decompiled with CFR 0.152.
 */
package dev.likemagic.bluebreeze;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import dev.likemagic.bluebreeze.BBAuthorization;
import dev.likemagic.bluebreeze.BBDevice;
import dev.likemagic.bluebreeze.BBError;
import dev.likemagic.bluebreeze.BBManager;
import dev.likemagic.bluebreeze.BBManagerKt;
import dev.likemagic.bluebreeze.BBScanResult;
import dev.likemagic.bluebreeze.BBState;
import dev.likemagic.bluebreeze.BBUUID;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010-\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010.\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/J\u000e\u00101\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003J\u001c\u00104\u001a\u00020\u00132\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u00105\u001a\u0004\u0018\u000106H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR \u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001c0\u001b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001c0\u001b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\fR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\n8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\fR\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020%0'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Ldev/likemagic/bluebreeze/BBManager;", "Landroid/content/BroadcastReceiver;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "_authorizationStatus", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Ldev/likemagic/bluebreeze/BBAuthorization;", "authorizationStatus", "Lkotlinx/coroutines/flow/StateFlow;", "getAuthorizationStatus", "()Lkotlinx/coroutines/flow/StateFlow;", "authorizationPermissions", "", "", "[Ljava/lang/String;", "authorizationCheck", "authorizationRequest", "", "authorizationOpenSettings", "_state", "Ldev/likemagic/bluebreeze/BBState;", "state", "getState", "stateCheck", "_devices", "", "Ldev/likemagic/bluebreeze/BBDevice;", "devices", "getDevices", "_scanEnabled", "", "scanEnabled", "getScanEnabled", "_scanResults", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Ldev/likemagic/bluebreeze/BBScanResult;", "scanResults", "Lkotlinx/coroutines/flow/SharedFlow;", "getScanResults", "()Lkotlinx/coroutines/flow/SharedFlow;", "scanTimes", "", "", "scanStart", "serviceUUIDs", "", "Ldev/likemagic/bluebreeze/BBUUID;", "scanStop", "scanCallback", "Landroid/bluetooth/le/ScanCallback;", "onReceive", "intent", "Landroid/content/Intent;", "BBPermissionRequestActivity", "bluebreeze_release"})
@SourceDebugExtension(value={"SMAP\nBBManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BBManager.kt\ndev/likemagic/bluebreeze/BBManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,459:1\n11158#2:460\n11493#2,3:461\n11158#2:467\n11493#2,3:468\n12567#2,2:474\n13402#2,2:476\n1734#3,3:464\n1755#3,3:471\n1557#3:478\n1628#3,3:479\n*S KotlinDebug\n*F\n+ 1 BBManager.kt\ndev/likemagic/bluebreeze/BBManager\n*L\n65#1:460\n65#1:461,3\n72#1:467\n72#1:468,3\n79#1:474,2\n115#1:476,2\n66#1:464,3\n73#1:471,3\n245#1:478\n245#1:479,3\n*E\n"})
public final class BBManager
extends BroadcastReceiver {
    @NotNull
    private final MutableStateFlow<BBAuthorization> _authorizationStatus;
    @NotNull
    private final String[] authorizationPermissions;
    @NotNull
    private final MutableStateFlow<BBState> _state;
    @NotNull
    private final MutableStateFlow<Map<String, BBDevice>> _devices;
    @NotNull
    private final MutableStateFlow<Boolean> _scanEnabled;
    @NotNull
    private final MutableSharedFlow<BBScanResult> _scanResults;
    @NotNull
    private final List<Long> scanTimes;
    @NotNull
    private final ScanCallback scanCallback;

    public BBManager(@NotNull Context context) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this._authorizationStatus = StateFlowKt.MutableStateFlow((Object)((Object)BBAuthorization.unknown));
        if (Build.VERSION.SDK_INT >= 31) {
            String[] stringArray2 = new String[]{"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_CONNECT"};
            stringArray = stringArray2;
        } else {
            String[] stringArray3 = new String[]{"android.permission.BLUETOOTH", "android.permission.ACCESS_FINE_LOCATION"};
            stringArray = stringArray3;
        }
        this.authorizationPermissions = stringArray;
        this._authorizationStatus.setValue((Object)this.authorizationCheck(context));
        this._state = StateFlowKt.MutableStateFlow((Object)((Object)BBState.unknown));
        this._state.setValue((Object)this.stateCheck(context));
        this._devices = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
        this._scanEnabled = StateFlowKt.MutableStateFlow((Object)false);
        this._scanResults = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.scanTimes = new ArrayList();
        this.scanCallback = new ScanCallback(this, context){
            final /* synthetic */ BBManager this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            private final Map<UByte, byte[]> parseAdvertisedData(byte[] advertisedData) {
                byte length;
                Map result = new LinkedHashMap<K, V>();
                ByteBuffer buffer = BBManagerKt.byteBuffer(advertisedData);
                while (buffer.remaining() > 2 && (length = buffer.get()) != 0 && length <= buffer.remaining()) {
                    byte type = UByte.constructor-impl((byte)buffer.get());
                    byte[] value = new byte[length - 1];
                    int n = length - 1;
                    for (int index = 0; index < n; ++index) {
                        value[index] = buffer.get();
                    }
                    UByte uByte = UByte.box-impl((byte)type);
                    result.put(uByte, value);
                }
                return result;
            }

            private final List<BBUUID> parseAdvertisedServices(Map<UByte, byte[]> advertisedData) {
                List uuids = new ArrayList<E>();
                for (Map.Entry<UByte, byte[]> entry : advertisedData.entrySet()) {
                    List bytes;
                    Collection collection;
                    int item$iv$iv;
                    Iterator<T> iterator;
                    Iterable $this$mapTo$iv$iv;
                    boolean $i$f$mapTo;
                    Collection destination$iv$iv;
                    Iterable $this$map$iv;
                    ByteBuffer buffer = ByteBuffer.wrap(entry.getValue());
                    byte by = entry.getKey().unbox-impl();
                    if (by == 2 || by == 3) {
                        while (buffer.remaining() >= 2) {
                            $this$map$iv = (Iterable)RangesKt.until((int)0, (int)2);
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            iterator = $this$mapTo$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                                collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(buffer.get());
                            }
                            bytes = (List)destination$iv$iv;
                            String uuidShort = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)bytes), (CharSequence)"", null, null, (int)0, null, scanCallback.1::parseAdvertisedServices$lambda$1, (int)30, null);
                            uuids.add(BBUUID.Companion.fromString(uuidShort));
                        }
                        continue;
                    }
                    if (by != 6 && by != 7) continue;
                    while (buffer.remaining() >= 16) {
                        $this$map$iv = (Iterable)RangesKt.until((int)0, (int)16);
                        boolean $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            int it = item$iv$iv = ((IntIterator)iterator).nextInt();
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(buffer.get());
                        }
                        bytes = (List)destination$iv$iv;
                        Object[] objectArray = new String[]{CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)bytes.subList(12, 16)), (CharSequence)"", null, null, (int)0, null, scanCallback.1::parseAdvertisedServices$lambda$3, (int)30, null), CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)bytes.subList(10, 12)), (CharSequence)"", null, null, (int)0, null, scanCallback.1::parseAdvertisedServices$lambda$4, (int)30, null), CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)bytes.subList(8, 10)), (CharSequence)"", null, null, (int)0, null, scanCallback.1::parseAdvertisedServices$lambda$5, (int)30, null), CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)bytes.subList(6, 8)), (CharSequence)"", null, null, (int)0, null, scanCallback.1::parseAdvertisedServices$lambda$6, (int)30, null), CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)bytes.subList(0, 6)), (CharSequence)"", null, null, (int)0, null, scanCallback.1::parseAdvertisedServices$lambda$7, (int)30, null)};
                        String uuid = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
                        uuids.add(BBUUID.Companion.fromString(uuid));
                    }
                }
                return uuids;
            }

            /*
             * WARNING - void declaration
             */
            private final void processScanResult(ScanResult result) {
                Object object;
                BBDevice device;
                block6: {
                    block5: {
                        BBDevice bBDevice = (BBDevice)((Map)this.this$0.getDevices().getValue()).get(result.getDevice().getAddress());
                        if (bBDevice == null) {
                            BluetoothDevice bluetoothDevice = result.getDevice();
                            Intrinsics.checkNotNullExpressionValue((Object)bluetoothDevice, (String)"getDevice(...)");
                            bBDevice = device = new BBDevice(this.$context, bluetoothDevice);
                        }
                        if (((Map)this.this$0.getDevices().getValue()).get(result.getDevice().getAddress()) == null) {
                            void $this$processScanResult_u24lambda_u248;
                            Map map;
                            Map map2 = map = MapsKt.toMutableMap((Map)((Map)this.this$0.getDevices().getValue()));
                            MutableStateFlow mutableStateFlow = BBManager.access$get_devices$p(this.this$0);
                            boolean bl = false;
                            $this$processScanResult_u24lambda_u248.put(device.getAddress(), device);
                            mutableStateFlow.setValue((Object)map);
                        }
                        if ((object = result.getScanRecord()) == null) break block5;
                        byte[] byArray = object.getBytes();
                        object = byArray;
                        if (byArray == null) break block5;
                        Object it = object;
                        boolean bl = false;
                        Map<UByte, byte[]> map = this.parseAdvertisedData((byte[])it);
                        object = map;
                        if (map != null) break block6;
                    }
                    object = MapsKt.emptyMap();
                }
                Object advertisementData = object;
                boolean connectable = Build.VERSION.SDK_INT < 26 ? true : result.isConnectable();
                BBScanResult scanResult = new BBScanResult(device, result.getRssi(), (Map<UByte, byte[]>)advertisementData, this.parseAdvertisedServices((Map<UByte, byte[]>)advertisementData), connectable);
                BBManager.access$get_scanResults$p(this.this$0).tryEmit((Object)scanResult);
            }

            public void onScanResult(int callbackType, ScanResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                super.onScanResult(callbackType, result);
                this.processScanResult(result);
            }

            public void onBatchScanResults(List<ScanResult> results) {
                Intrinsics.checkNotNullParameter(results, (String)"results");
                super.onBatchScanResults(results);
                Iterable $this$forEach$iv = results;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ScanResult it = (ScanResult)element$iv;
                    boolean bl = false;
                    this.processScanResult(it);
                }
            }

            public void onScanFailed(int errorCode) {
                super.onScanFailed(errorCode);
                BBManager.access$get_scanEnabled$p(this.this$0).setValue((Object)false);
            }

            private static final CharSequence parseAdvertisedServices$lambda$1(byte it) {
                return BBManagerKt.getHexString(it);
            }

            private static final CharSequence parseAdvertisedServices$lambda$3(byte it) {
                return BBManagerKt.getHexString(it);
            }

            private static final CharSequence parseAdvertisedServices$lambda$4(byte it) {
                return BBManagerKt.getHexString(it);
            }

            private static final CharSequence parseAdvertisedServices$lambda$5(byte it) {
                return BBManagerKt.getHexString(it);
            }

            private static final CharSequence parseAdvertisedServices$lambda$6(byte it) {
                return BBManagerKt.getHexString(it);
            }

            private static final CharSequence parseAdvertisedServices$lambda$7(byte it) {
                return BBManagerKt.getHexString(it);
            }
        };
    }

    @NotNull
    public final StateFlow<BBAuthorization> getAuthorizationStatus() {
        return (StateFlow)this._authorizationStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final BBAuthorization authorizationCheck(Context context) {
        boolean bl;
        block14: {
            boolean bl2;
            boolean $i$f$any;
            String[] $this$any$iv;
            block13: {
                void $this$mapTo$iv$iv;
                Object element$iv22;
                boolean bl3;
                Collection collection;
                int n;
                block12: {
                    Iterator $this$mapTo$iv$iv2;
                    String[] $this$map$iv = this.authorizationPermissions;
                    boolean $i$f$map = false;
                    String[] stringArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean bl4 = false;
                    n = ((void)$this$mapTo$iv$iv2).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var11_21 = item$iv$iv = $this$mapTo$iv$iv2[i];
                        collection = destination$iv$iv;
                        boolean bl42 = false;
                        collection.add(ContextCompat.checkSelfPermission((Context)context, (String)it));
                    }
                    List granted = (List)destination$iv$iv;
                    Iterable $this$all$iv = granted;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv22 : $this$all$iv) {
                            int n2 = ((Number)element$iv22).intValue();
                            boolean bl5 = false;
                            if (n2 == 0) continue;
                            bl3 = false;
                            break block12;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) {
                    return BBAuthorization.authorized;
                }
                String[] $this$map$iv = this.authorizationPermissions;
                boolean $i$f$map = false;
                element$iv22 = $this$map$iv;
                Collection n3 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int item$iv$iv = ((void)$this$mapTo$iv$iv).length;
                for (n = 0; n < item$iv$iv; ++n) {
                    void it;
                    void item$iv$iv2;
                    void bl42 = item$iv$iv2 = $this$mapTo$iv$iv[n];
                    collection = n3;
                    boolean bl6 = false;
                    collection.add(BBManagerKt.getSharedPreferences(context).getBoolean((String)it, false));
                }
                List requested = (List)n3;
                $this$any$iv = (String[])requested;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object t : $this$any$iv) {
                        boolean it = (Boolean)t;
                        boolean bl7 = false;
                        if (!(!it)) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return BBAuthorization.unknown;
            }
            $this$any$iv = this.authorizationPermissions;
            $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl8 = false;
                boolean bl5 = context instanceof Activity && ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)context), (String)it);
                if (!bl5) continue;
                bl = true;
                break block14;
            }
            bl = false;
        }
        if (bl) {
            return BBAuthorization.showRationale;
        }
        return BBAuthorization.denied;
    }

    public final void authorizationRequest(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("BBPermissionRequestActivity.granted");
        intentFilter.addAction("BBPermissionRequestActivity.showRationale");
        intentFilter.addAction("BBPermissionRequestActivity.denied");
        Intent intent = Build.VERSION.SDK_INT < 33 ? context.registerReceiver((BroadcastReceiver)this, intentFilter) : context.registerReceiver((BroadcastReceiver)this, intentFilter, 4);
        Intent intent2 = new Intent(context, BBPermissionRequestActivity.class);
        intent2.putExtra("BBPermissionRequestActivity.key", this.authorizationPermissions);
        context.startActivity(intent2);
        SharedPreferences.Editor editor = BBManagerKt.getSharedPreferences(context).edit();
        String[] $this$forEach$iv = this.authorizationPermissions;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            editor.putBoolean(it, true);
        }
        editor.apply();
    }

    public final void authorizationOpenSettings(@NotNull Context context) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent $this$authorizationOpenSettings_u24lambda_u246 = intent = new Intent();
        boolean bl = false;
        $this$authorizationOpenSettings_u24lambda_u246.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        $this$authorizationOpenSettings_u24lambda_u246.addCategory("android.intent.category.DEFAULT");
        $this$authorizationOpenSettings_u24lambda_u246.setData(Uri.parse((String)("package:" + context.getPackageName())));
        Intent intent2 = intent;
        context.startActivity(intent2);
    }

    @NotNull
    public final StateFlow<BBState> getState() {
        return (StateFlow)this._state;
    }

    private final BBState stateCheck(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        Intent intent = Build.VERSION.SDK_INT >= 33 ? context.registerReceiver((BroadcastReceiver)this, intentFilter, 4) : context.registerReceiver((BroadcastReceiver)this, intentFilter);
        BluetoothAdapter bluetoothAdapter = BBManagerKt.getBluetoothAdapter(context);
        return Intrinsics.areEqual((Object)(bluetoothAdapter != null ? Boolean.valueOf(bluetoothAdapter.isEnabled()) : null), (Object)true) ? BBState.poweredOn : BBState.poweredOff;
    }

    @NotNull
    public final StateFlow<Map<String, BBDevice>> getDevices() {
        return (StateFlow)this._devices;
    }

    @NotNull
    public final StateFlow<Boolean> getScanEnabled() {
        return (StateFlow)this._scanEnabled;
    }

    @NotNull
    public final SharedFlow<BBScanResult> getScanResults() {
        return (SharedFlow)this._scanResults;
    }

    /*
     * WARNING - void declaration
     */
    public final void scanStart(@NotNull Context context, @Nullable List<BBUUID> serviceUUIDs) {
        boolean bl;
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (((Boolean)this.getScanEnabled().getValue()).booleanValue()) {
            return;
        }
        int bluetoothScanMode = 2;
        ScanSettings.Builder scanSettingsBuilder = new ScanSettings.Builder();
        scanSettingsBuilder.setScanMode(bluetoothScanMode);
        if (Build.VERSION.SDK_INT >= 23) {
            scanSettingsBuilder.setCallbackType(1);
        }
        ScanSettings scanSettings = scanSettingsBuilder.build();
        List<BBUUID> list2 = serviceUUIDs;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BBUUID bBUUID = (BBUUID)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new ScanFilter.Builder().setServiceUuid(it.getParcelUUID()).build());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List scanFilters = list;
        long currentTime = System.currentTimeMillis();
        if (this.scanTimes.size() < 5) {
            bl = this.scanTimes.add(currentTime);
        } else {
            long deltaTime = currentTime - ((Number)this.scanTimes.get(0)).longValue();
            if (deltaTime < 30000L) {
                float timeToWait = 30.0f - (float)deltaTime * 0.001f;
                throw BBError.Companion.scan(timeToWait);
            }
            this.scanTimes.remove(0);
            bl = this.scanTimes.add(currentTime);
        }
        BluetoothLeScanner bluetoothLeScanner = BBManagerKt.getBluetoothLeScanner(context);
        if (bluetoothLeScanner != null) {
            bluetoothLeScanner.startScan(scanFilters, scanSettings, this.scanCallback);
        }
        this._scanEnabled.setValue((Object)true);
    }

    public static /* synthetic */ void scanStart$default(BBManager bBManager, Context context, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        bBManager.scanStart(context, list);
    }

    public final void scanStop(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!((Boolean)this.getScanEnabled().getValue()).booleanValue()) {
            return;
        }
        BluetoothLeScanner bluetoothLeScanner = BBManagerKt.getBluetoothLeScanner(context);
        if (bluetoothLeScanner != null) {
            bluetoothLeScanner.stopScan(this.scanCallback);
        }
        this._scanEnabled.setValue((Object)false);
    }

    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        block20: {
            Intent intent2 = intent;
            if (intent2 == null) break block20;
            Intent it = intent2;
            boolean bl = false;
            String string = intent.getAction();
            if (string == null) break block20;
            int n = -1;
            switch (string.hashCode()) {
                case 674944859: {
                    if (string.equals("BBPermissionRequestActivity.showRationale")) {
                        n = 1;
                    }
                    break;
                }
                case -1157682084: {
                    if (string.equals("BBPermissionRequestActivity.granted")) {
                        n = 2;
                    }
                    break;
                }
                case -1658876454: {
                    if (string.equals("BBPermissionRequestActivity.denied")) {
                        n = 3;
                    }
                    break;
                }
                case -1530327060: {
                    if (string.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                        n = 4;
                    }
                    break;
                }
            }
            block6 : switch (n) {
                case 2: {
                    this._authorizationStatus.setValue((Object)BBAuthorization.authorized);
                    break;
                }
                case 1: {
                    this._authorizationStatus.setValue((Object)BBAuthorization.showRationale);
                    break;
                }
                case 3: {
                    this._authorizationStatus.setValue((Object)BBAuthorization.denied);
                    break;
                }
                case 4: {
                    switch (intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1)) {
                        case 10: {
                            this._state.setValue((Object)BBState.poweredOff);
                            break block6;
                        }
                        case 12: {
                            this._state.setValue((Object)BBState.poweredOn);
                        }
                    }
                }
            }
        }
    }

    public static final /* synthetic */ MutableStateFlow access$get_devices$p(BBManager $this) {
        return $this._devices;
    }

    public static final /* synthetic */ MutableSharedFlow access$get_scanResults$p(BBManager $this) {
        return $this._scanResults;
    }

    public static final /* synthetic */ MutableStateFlow access$get_scanEnabled$p(BBManager $this) {
        return $this._scanEnabled;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J-\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Ldev/likemagic/bluebreeze/BBManager$BBPermissionRequestActivity;", "Landroid/app/Activity;", "<init>", "()V", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "Companion", "bluebreeze_release"})
    @SourceDebugExtension(value={"SMAP\nBBManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BBManager.kt\ndev/likemagic/bluebreeze/BBManager$BBPermissionRequestActivity\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,459:1\n11158#2:460\n11493#2,3:461\n12406#2,2:464\n1755#3,3:466\n*S KotlinDebug\n*F\n+ 1 BBManager.kt\ndev/likemagic/bluebreeze/BBManager$BBPermissionRequestActivity\n*L\n154#1:460\n154#1:461,3\n160#1:464,2\n162#1:466,3\n*E\n"})
    public static final class BBPermissionRequestActivity
    extends Activity {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String KEY = "BBPermissionRequestActivity.key";
        @NotNull
        public static final String GRANTED = "BBPermissionRequestActivity.granted";
        @NotNull
        public static final String SHOW_RATIONALE = "BBPermissionRequestActivity.showRationale";
        @NotNull
        public static final String DENIED = "BBPermissionRequestActivity.denied";

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            if (savedInstanceState == null) {
                Activity activity = this;
                String[] stringArray = this.getIntent().getStringArrayExtra(KEY);
                if (stringArray == null) {
                    stringArray = new String[]{};
                }
                ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
            String string;
            boolean bl;
            Iterable $this$all$iv;
            List shouldShowRationale;
            Object object;
            block7: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
                Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
                Object[] $this$map$iv = permissions;
                boolean $i$f$map = false;
                String[] stringArray = $this$map$iv;
                Collection destination$iv$iv22 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var13_16 = item$iv$iv = $this$mapTo$iv$iv[i];
                    object = destination$iv$iv22;
                    boolean bl2 = false;
                    object.add(ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)it));
                }
                shouldShowRationale = (List)destination$iv$iv22;
                $this$map$iv = grantResults;
                object = this;
                boolean $i$f$all = false;
                int destination$iv$iv22 = ((void)$this$all$iv).length;
                for (int i = 0; i < destination$iv$iv22; ++i) {
                    void element$iv;
                    void it = element$iv = $this$all$iv[i];
                    boolean bl3 = false;
                    if (it == false) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            boolean bl4 = bl;
            Object object2 = object;
            if (bl4) {
                string = GRANTED;
            } else {
                boolean bl5;
                block8: {
                    void $this$any$iv;
                    $this$all$iv = shouldShowRationale;
                    object = object2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean it = (Boolean)element$iv;
                            boolean bl6 = false;
                            if (!it) continue;
                            bl5 = true;
                            break block8;
                        }
                        bl5 = false;
                    }
                }
                bl4 = bl5;
                object2 = object;
                string = bl4 ? SHOW_RATIONALE : DENIED;
            }
            String string2 = string;
            object2.sendBroadcast(new Intent(string2).setPackage(this.getPackageName()));
            this.finish();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldev/likemagic/bluebreeze/BBManager$BBPermissionRequestActivity$Companion;", "", "<init>", "()V", "KEY", "", "GRANTED", "SHOW_RATIONALE", "DENIED", "bluebreeze_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

