/*
 * Decompiled with CFR 0.152.
 */
package dev.likemagic.bluebreeze.operations;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.content.Context;
import dev.likemagic.bluebreeze.BBError;
import dev.likemagic.bluebreeze.BBOperation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\"\u0010\u000e\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/likemagic/bluebreeze/operations/BBOperationConnect;", "Ldev/likemagic/bluebreeze/BBOperation;", "", "gattCallback", "Landroid/bluetooth/BluetoothGattCallback;", "<init>", "(Landroid/bluetooth/BluetoothGattCallback;)V", "execute", "context", "Landroid/content/Context;", "device", "Landroid/bluetooth/BluetoothDevice;", "gatt", "Landroid/bluetooth/BluetoothGatt;", "onConnectionStateChange", "status", "", "newState", "bluebreeze_release"})
public final class BBOperationConnect
extends BBOperation<Unit> {
    @NotNull
    private final BluetoothGattCallback gattCallback;

    public BBOperationConnect(@NotNull BluetoothGattCallback gattCallback) {
        Intrinsics.checkNotNullParameter((Object)gattCallback, (String)"gattCallback");
        this.gattCallback = gattCallback;
    }

    @Override
    public void execute(@NotNull Context context, @NotNull BluetoothDevice device, @Nullable BluetoothGatt gatt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        device.connectGatt(context, false, this.gattCallback);
    }

    @Override
    public void onConnectionStateChange(@Nullable BluetoothGatt gatt, int status, int newState) {
        if (status == 0) {
            switch (newState) {
                case 2: {
                    this.setSuccess(Unit.INSTANCE);
                    break;
                }
                case 0: {
                    this.setError(BBError.Companion.gattDisconnected());
                }
            }
        } else {
            this.setError(BBError.Companion.gattError(status));
        }
    }
}

