/*
 * Decompiled with CFR 0.152.
 */
package dev.likemagic.bluebreeze.operations;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import android.os.Build;
import dev.likemagic.bluebreeze.BBConstants;
import dev.likemagic.bluebreeze.BBError;
import dev.likemagic.bluebreeze.BBOperation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J$\u0010\u0012\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Ldev/likemagic/bluebreeze/operations/BBOperationSubscribe;", "Ldev/likemagic/bluebreeze/BBOperation;", "", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "<init>", "(Landroid/bluetooth/BluetoothGattCharacteristic;)V", "writeValue", "", "getWriteValue", "()[B", "execute", "context", "Landroid/content/Context;", "device", "Landroid/bluetooth/BluetoothDevice;", "gatt", "Landroid/bluetooth/BluetoothGatt;", "onDescriptorWrite", "descriptor", "Landroid/bluetooth/BluetoothGattDescriptor;", "status", "", "bluebreeze_release"})
public final class BBOperationSubscribe
extends BBOperation<Unit> {
    @NotNull
    private final BluetoothGattCharacteristic characteristic;

    public BBOperationSubscribe(@NotNull BluetoothGattCharacteristic characteristic) {
        Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
        this.characteristic = characteristic;
    }

    private final byte[] getWriteValue() {
        byte[] byArray;
        if ((this.characteristic.getProperties() & 0x10) != 0) {
            byArray = BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE, (String)"ENABLE_NOTIFICATION_VALUE");
        } else {
            byArray = BluetoothGattDescriptor.ENABLE_INDICATION_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)BluetoothGattDescriptor.ENABLE_INDICATION_VALUE, (String)"ENABLE_INDICATION_VALUE");
        }
        return byArray;
    }

    @Override
    public void execute(@NotNull Context context, @NotNull BluetoothDevice device, @Nullable BluetoothGatt gatt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        if (gatt == null) {
            BBOperationSubscribe $this$execute_u24lambda_u240 = this;
            boolean bl = false;
            $this$execute_u24lambda_u240.setError(BBError.Companion.gattDisconnected());
            return;
        }
        BluetoothGattDescriptor bluetoothGattDescriptor = this.characteristic.getDescriptor(BBConstants.UUID.INSTANCE.getCccd());
        if (bluetoothGattDescriptor == null) {
            BBOperationSubscribe $this$execute_u24lambda_u241 = this;
            boolean bl = false;
            $this$execute_u24lambda_u241.setError(BBError.Companion.gattError$default(BBError.Companion, null, 1, null));
            return;
        }
        BluetoothGattDescriptor descriptor = bluetoothGattDescriptor;
        if (!gatt.setCharacteristicNotification(this.characteristic, true)) {
            this.setError(BBError.Companion.gattError$default(BBError.Companion, null, 1, null));
            return;
        }
        if (Build.VERSION.SDK_INT < 33) {
            descriptor.setValue(this.getWriteValue());
            if (!gatt.writeDescriptor(descriptor)) {
                this.setError(BBError.Companion.gattError$default(BBError.Companion, null, 1, null));
            }
        } else if (gatt.writeDescriptor(descriptor, this.getWriteValue()) != 0) {
            this.setError(BBError.Companion.gattError$default(BBError.Companion, null, 1, null));
        }
    }

    public void onDescriptorWrite(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattDescriptor descriptor, int status) {
        if (gatt == null) {
            BBOperationSubscribe $this$onDescriptorWrite_u24lambda_u242 = this;
            boolean bl = false;
            $this$onDescriptorWrite_u24lambda_u242.setError(BBError.Companion.gattDisconnected());
            return;
        }
        if (descriptor == null) {
            BBOperationSubscribe $this$onDescriptorWrite_u24lambda_u243 = this;
            boolean bl = false;
            $this$onDescriptorWrite_u24lambda_u243.setError(BBError.Companion.gattDisconnected());
            return;
        }
        if (!Intrinsics.areEqual((Object)descriptor.getUuid(), (Object)BBConstants.UUID.INSTANCE.getCccd())) {
            return;
        }
        if (status == 0) {
            this.setSuccess(Unit.INSTANCE);
        } else {
            this.setError(BBError.Companion.gattError(status));
        }
    }
}

