/*
 * Decompiled with CFR 0.152.
 */
package dev.likemagic.bluebreeze.operations;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.content.Context;
import android.os.Build;
import dev.likemagic.bluebreeze.BBError;
import dev.likemagic.bluebreeze.BBOperation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J$\u0010\u0012\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/likemagic/bluebreeze/operations/BBOperationWrite;", "Ldev/likemagic/bluebreeze/BBOperation;", "", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "data", "", "withResponse", "", "<init>", "(Landroid/bluetooth/BluetoothGattCharacteristic;[BZ)V", "execute", "context", "Landroid/content/Context;", "device", "Landroid/bluetooth/BluetoothDevice;", "gatt", "Landroid/bluetooth/BluetoothGatt;", "onCharacteristicWrite", "status", "", "bluebreeze_release"})
public final class BBOperationWrite
extends BBOperation<Unit> {
    @NotNull
    private final BluetoothGattCharacteristic characteristic;
    @NotNull
    private final byte[] data;
    private final boolean withResponse;

    public BBOperationWrite(@NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] data, boolean withResponse) {
        Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.characteristic = characteristic;
        this.data = data;
        this.withResponse = withResponse;
    }

    @Override
    public void execute(@NotNull Context context, @NotNull BluetoothDevice device, @Nullable BluetoothGatt gatt) {
        int writeType;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        if (gatt == null) {
            BBOperationWrite $this$execute_u24lambda_u240 = this;
            boolean bl = false;
            $this$execute_u24lambda_u240.setError(BBError.Companion.gattDisconnected());
            return;
        }
        int n = writeType = this.withResponse ? 2 : 1;
        if (Build.VERSION.SDK_INT < 33) {
            this.characteristic.setValue(this.data);
            this.characteristic.setWriteType(writeType);
            gatt.writeCharacteristic(this.characteristic);
        } else {
            gatt.writeCharacteristic(this.characteristic, this.data, writeType);
        }
    }

    public void onCharacteristicWrite(@Nullable BluetoothGatt gatt, @Nullable BluetoothGattCharacteristic characteristic, int status) {
        if (status == 0) {
            this.setSuccess(Unit.INSTANCE);
        } else {
            this.setError(BBError.Companion.gattError(status));
        }
    }
}

