/*
 * Decompiled with CFR 0.152.
 */
package dev.likemagic.bluebreeze;

import dev.likemagic.bluebreeze.BBConstants;
import dev.likemagic.bluebreeze.BBDevice;
import dev.likemagic.bluebreeze.BBUUID;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\t\u0010-\u001a\u00020\u000eH\u00c6\u0003JM\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010/\u001a\u00020\u000e2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00101\u001a\u00020\u0005H\u00d6\u0001J\t\u00102\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0013\u0010!\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0013\u0010$\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001e\u00a8\u00063"}, d2={"Ldev/likemagic/bluebreeze/BBScanResult;", "", "device", "Ldev/likemagic/bluebreeze/BBDevice;", "rssi", "", "advertisementData", "", "Lkotlin/UByte;", "", "advertisedServices", "", "Ldev/likemagic/bluebreeze/BBUUID;", "connectable", "", "<init>", "(Ldev/likemagic/bluebreeze/BBDevice;ILjava/util/Map;Ljava/util/List;Z)V", "getDevice", "()Ldev/likemagic/bluebreeze/BBDevice;", "getRssi", "()I", "getAdvertisementData", "()Ljava/util/Map;", "getAdvertisedServices", "()Ljava/util/List;", "getConnectable", "()Z", "address", "", "getAddress", "()Ljava/lang/String;", "name", "getName", "manufacturerData", "getManufacturerData", "()[B", "manufacturerId", "getManufacturerId", "()Ljava/lang/Integer;", "manufacturerName", "getManufacturerName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "bluebreeze_release"})
public final class BBScanResult {
    @NotNull
    private final BBDevice device;
    private final int rssi;
    @NotNull
    private final Map<UByte, byte[]> advertisementData;
    @NotNull
    private final List<BBUUID> advertisedServices;
    private final boolean connectable;

    public BBScanResult(@NotNull BBDevice device, int rssi, @NotNull Map<UByte, byte[]> advertisementData, @NotNull List<BBUUID> advertisedServices, boolean connectable) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter(advertisementData, (String)"advertisementData");
        Intrinsics.checkNotNullParameter(advertisedServices, (String)"advertisedServices");
        this.device = device;
        this.rssi = rssi;
        this.advertisementData = advertisementData;
        this.advertisedServices = advertisedServices;
        this.connectable = connectable;
    }

    @NotNull
    public final BBDevice getDevice() {
        return this.device;
    }

    public final int getRssi() {
        return this.rssi;
    }

    @NotNull
    public final Map<UByte, byte[]> getAdvertisementData() {
        return this.advertisementData;
    }

    @NotNull
    public final List<BBUUID> getAdvertisedServices() {
        return this.advertisedServices;
    }

    public final boolean getConnectable() {
        return this.connectable;
    }

    @NotNull
    public final String getAddress() {
        return this.device.getAddress();
    }

    @Nullable
    public final String getName() {
        String string = this.device.getName();
        if (string == null) {
            String string2;
            Object object;
            byte[] byArray = this.advertisementData.get(UByte.box-impl((byte)9));
            if (byArray != null) {
                byte[] byArray2 = byArray;
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
                object = charset;
                string2 = new String(byArray2, (Charset)object);
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                String string3;
                Charset charset;
                byte[] byArray3 = this.advertisementData.get(UByte.box-impl((byte)8));
                if (byArray3 != null) {
                    object = byArray3;
                    Charset charset2 = Charset.defaultCharset();
                    Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"defaultCharset(...)");
                    charset = charset2;
                    string3 = new String((byte[])object, charset);
                } else {
                    string3 = string = null;
                }
                if (string3 == null) {
                    byte[] byArray4 = this.advertisementData.get(UByte.box-impl((byte)48));
                    if (byArray4 != null) {
                        object = byArray4;
                        Charset charset3 = Charset.defaultCharset();
                        Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"defaultCharset(...)");
                        charset = charset3;
                        string = new String((byte[])object, charset);
                    } else {
                        string = null;
                    }
                }
            }
        }
        return string;
    }

    @Nullable
    public final byte[] getManufacturerData() {
        return this.advertisementData.get(UByte.box-impl((byte)-1));
    }

    @Nullable
    public final Integer getManufacturerId() {
        byte[] byArray = this.getManufacturerData();
        if (byArray == null) {
            return null;
        }
        byte[] manufacturerData = byArray;
        return (UByte.constructor-impl((byte)manufacturerData[1]) & 0xFF) << 8 | UByte.constructor-impl((byte)manufacturerData[0]) & 0xFF;
    }

    @Nullable
    public final String getManufacturerName() {
        Integer n = this.getManufacturerId();
        if (n == null) {
            return null;
        }
        int manufacturerId = n;
        return BBConstants.Manufacturer.INSTANCE.getKnownIds().get(manufacturerId);
    }

    @NotNull
    public final BBDevice component1() {
        return this.device;
    }

    public final int component2() {
        return this.rssi;
    }

    @NotNull
    public final Map<UByte, byte[]> component3() {
        return this.advertisementData;
    }

    @NotNull
    public final List<BBUUID> component4() {
        return this.advertisedServices;
    }

    public final boolean component5() {
        return this.connectable;
    }

    @NotNull
    public final BBScanResult copy(@NotNull BBDevice device, int rssi, @NotNull Map<UByte, byte[]> advertisementData, @NotNull List<BBUUID> advertisedServices, boolean connectable) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter(advertisementData, (String)"advertisementData");
        Intrinsics.checkNotNullParameter(advertisedServices, (String)"advertisedServices");
        return new BBScanResult(device, rssi, advertisementData, advertisedServices, connectable);
    }

    public static /* synthetic */ BBScanResult copy$default(BBScanResult bBScanResult, BBDevice bBDevice, int n, Map map, List list, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bBDevice = bBScanResult.device;
        }
        if ((n2 & 2) != 0) {
            n = bBScanResult.rssi;
        }
        if ((n2 & 4) != 0) {
            map = bBScanResult.advertisementData;
        }
        if ((n2 & 8) != 0) {
            list = bBScanResult.advertisedServices;
        }
        if ((n2 & 0x10) != 0) {
            bl = bBScanResult.connectable;
        }
        return bBScanResult.copy(bBDevice, n, map, list, bl);
    }

    @NotNull
    public String toString() {
        return "BBScanResult(device=" + this.device + ", rssi=" + this.rssi + ", advertisementData=" + this.advertisementData + ", advertisedServices=" + this.advertisedServices + ", connectable=" + this.connectable + ")";
    }

    public int hashCode() {
        int result = this.device.hashCode();
        result = result * 31 + Integer.hashCode(this.rssi);
        result = result * 31 + ((Object)this.advertisementData).hashCode();
        result = result * 31 + ((Object)this.advertisedServices).hashCode();
        result = result * 31 + Boolean.hashCode(this.connectable);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BBScanResult)) {
            return false;
        }
        BBScanResult bBScanResult = (BBScanResult)other;
        if (!Intrinsics.areEqual((Object)this.device, (Object)bBScanResult.device)) {
            return false;
        }
        if (this.rssi != bBScanResult.rssi) {
            return false;
        }
        if (!Intrinsics.areEqual(this.advertisementData, bBScanResult.advertisementData)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.advertisedServices, bBScanResult.advertisedServices)) {
            return false;
        }
        return this.connectable == bBScanResult.connectable;
    }
}

