/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.service;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceClient {
    private static final Logger log = LoggerFactory.getLogger(ServiceClient.class);
    private static String baseUrl;
    private static ServiceClient instance;

    private ServiceClient() {
        String serviceHost = Optional.ofNullable(System.getProperty("service.host")).orElse("localhost");
        String servicePort = Optional.ofNullable(System.getProperty("service.mapped.port")).orElseThrow(() -> new RuntimeException("service.mapped.port property not found"));
        baseUrl = "http://" + serviceHost + ":" + servicePort;
        log.info("Service base URL is: " + baseUrl);
    }

    public static synchronized ServiceClient getInstance() {
        if (instance == null) {
            instance = new ServiceClient();
        }
        return instance;
    }

    public String getBaseUrl() {
        return baseUrl;
    }
}

