/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.wiremock;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.lydtech.component.framework.client.wiremock.RequestCriteria;
import dev.lydtech.component.framework.mapper.JsonMapper;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.InputStream;
import java.util.Optional;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WiremockClient {
    private static final Logger log = LoggerFactory.getLogger(WiremockClient.class);
    private ObjectMapper mapper;
    private RequestSpecification requestSpec;
    private static final String MAPPINGS_PATH = "/__admin/mappings";
    private static final String RESET_MAPPINGS_PATH = "/__admin/mappings/reset";
    private static final String DELETE_ALL_REQUESTS_PATH = "/__admin/requests";
    private static final String COUNT_REQUESTS_PATH = "/__admin/requests/count";
    private static final String FIND_REQUESTS_PATH = "/__admin/requests/find";
    private static WiremockClient instance;

    private WiremockClient() {
        String wiremockHost = Optional.ofNullable(System.getProperty("wiremock.host")).orElse("localhost");
        String wiremockPort = Optional.ofNullable(System.getProperty("wiremock.mapped.port")).orElseThrow(() -> new RuntimeException("wiremock.port property not found"));
        String baseUrl = "http://" + wiremockHost + ":" + wiremockPort;
        log.info("Wiremock base URL is: " + baseUrl);
        this.requestSpec = new RequestSpecBuilder().setBaseUri(baseUrl).build();
        this.mapper = new ObjectMapper();
    }

    public static synchronized WiremockClient getInstance() {
        if (instance == null) {
            instance = new WiremockClient();
        }
        return instance;
    }

    public void resetMappings() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).post(RESET_MAPPINGS_PATH, new Object[0])).then()).assertThat()).statusCode(200);
    }

    public String postMappingFile(String jsonFile) {
        String string;
        block8: {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(jsonFile);
            try {
                JsonNode jsonNode = (JsonNode)this.mapper.readValue(in, JsonNode.class);
                String jsonString = this.mapper.writeValueAsString((Object)jsonNode);
                string = this.postMapping(jsonString);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to post wiremock mapping file: " + jsonFile, (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return string;
    }

    public String postMapping(String request) {
        log.debug("Posting wiremock mapping: " + request);
        return (String)((Response)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).body(request).post(MAPPINGS_PATH, new Object[0])).then()).statusCode(201)).extract().response()).body().path("id", new String[0]);
    }

    public void deleteAllRequestsMappings() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).delete(DELETE_ALL_REQUESTS_PATH, new Object[0])).then()).assertThat()).statusCode(200);
    }

    public void countMatchingRequests(RequestCriteria request, Integer expectedCount) {
        this.countMatchingRequests(JsonMapper.writeToJson(request), expectedCount);
    }

    public void countMatchingRequests(String request, Integer expectedCount) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).body(request).post(COUNT_REQUESTS_PATH, new Object[0])).then()).statusCode(200)).assertThat()).body("count", Matchers.is((Object)expectedCount), new Object[0]);
    }

    public Response findMatchingRequests(RequestCriteria request) {
        return this.findMatchingRequests(JsonMapper.writeToJson(request));
    }

    public Response findMatchingRequests(String request) {
        log.info("Finding matching requests for: {}", (Object)request);
        return (Response)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).body(request).post(FIND_REQUESTS_PATH, new Object[0])).then()).statusCode(200)).extract().response();
    }
}

