/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.extension;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerPort;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import dev.lydtech.component.framework.extension.TestContainersConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DockerManager {
    private static final Logger log = LoggerFactory.getLogger(DockerManager.class);

    protected static DockerClient getDockerClient() {
        log.info("Check if services are running");
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost("unix:///var/run/docker.sock").build();
        ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
        return DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
    }

    protected static boolean shouldPerformSetup(DockerClient dockerClient) {
        List containers = (List)dockerClient.listContainersCmd().exec();
        boolean mainContainerPresent = containers.stream().filter(container -> Arrays.stream(container.getNames()).anyMatch(name -> name.startsWith("/" + TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-"))).anyMatch(container -> container.getLabels().entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).equals("dev.lydtech.main-container-label") && ((String)entry.getValue()).equals(TestContainersConfiguration.CONTAINER_MAIN_LABEL)));
        boolean testContainersPresent = containers.stream().anyMatch(container -> Arrays.stream(container.getNames()).anyMatch(name -> name.startsWith("/testcontainers-ryuk")));
        log.info("Current container status: main service with prefix ({}) and label ({}) running: {}, testcontainers running: {}", new Object[]{TestContainersConfiguration.CONTAINER_NAME_PREFIX, TestContainersConfiguration.CONTAINER_MAIN_LABEL, mainContainerPresent, testContainersPresent});
        return !mainContainerPresent || testContainersPresent;
    }

    protected static void captureDockerContainerPorts(DockerClient dockerClient) {
        log.info("Capturing Docker ports...");
        log.info("Container main label: " + TestContainersConfiguration.CONTAINER_MAIN_LABEL);
        ListContainersCmd listContainersCmd = dockerClient.listContainersCmd();
        List serviceContainers = (List)dockerClient.listContainersCmd().withNameFilter(Collections.singletonList(TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-")).withLabelFilter(Collections.singletonMap("dev.lydtech.main-container-label", TestContainersConfiguration.CONTAINER_MAIN_LABEL)).exec();
        if (serviceContainers.size() <= 0) {
            throw new RuntimeException("Service container not found");
        }
        Integer mappedPort = DockerManager.getMappedPort("Service", TestContainersConfiguration.SERVICE_PORT, serviceContainers);
        log.info("Service port " + TestContainersConfiguration.SERVICE_PORT + " is mapped to " + mappedPort);
        System.setProperty("service.mapped.port", mappedPort.toString());
        String postgresContainerName = TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-postgres";
        DockerManager.mapPorts("Postgres", TestContainersConfiguration.POSTGRES_ENABLED, listContainersCmd, postgresContainerName, TestContainersConfiguration.POSTGRES_PORT, "postgres");
        String kafkaContainerName = TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-kafka";
        DockerManager.mapPorts("Kafka", TestContainersConfiguration.KAFKA_ENABLED, listContainersCmd, kafkaContainerName, TestContainersConfiguration.KAFKA_PORT, "kafka");
        String debeziumContainerName = TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-debezium";
        DockerManager.mapPorts("Debezium", TestContainersConfiguration.DEBEZIUM_ENABLED, listContainersCmd, debeziumContainerName, TestContainersConfiguration.DEBEZIUM_PORT, "debezium");
        String wiremockContainerName = TestContainersConfiguration.CONTAINER_NAME_PREFIX + "-wiremock";
        DockerManager.mapPorts("Wiremock", TestContainersConfiguration.WIREMOCK_ENABLED, listContainersCmd, wiremockContainerName, TestContainersConfiguration.WIREMOCK_PORT, "wiremock");
        log.info("Docker ports captured.");
    }

    private static void mapPorts(String name, boolean enabled, ListContainersCmd listContainersCmd, String containerName, int port, String portParameterName) {
        List containers = (List)listContainersCmd.withNameFilter(Collections.singletonList(containerName)).exec();
        if (containers.size() > 1) {
            containers = containers.stream().filter(container -> Arrays.stream(container.getNames()).anyMatch(n -> n.equals("/" + containerName))).collect(Collectors.toList());
        }
        if (containers.size() == 1) {
            Integer mappedPort = DockerManager.getMappedPort(name, port, containers);
            log.info(name + " port " + port + " is mapped to " + mappedPort);
            System.setProperty(portParameterName + ".mapped.port", mappedPort.toString());
        } else {
            if (enabled) {
                log.error(name + " is enabled but single container is not found - containerName: {} - containers.size(): {} - port: {} - portParameterName: {}", new Object[]{containerName, containers.size(), port, portParameterName});
                throw new RuntimeException(name + " single container is not found.");
            }
            log.info(name + " container is not enabled");
        }
    }

    private static Integer getMappedPort(String name, int port, List<Container> containers) {
        return Arrays.stream(containers.get(0).getPorts()).filter(x -> Objects.equals(x.getPrivatePort(), port)).map(ContainerPort::getPublicPort).findFirst().orElseThrow(() -> new RuntimeException(name + " port not found"));
    }
}

