/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.extension;

import com.github.dockerjava.api.DockerClient;
import dev.lydtech.component.framework.extension.DockerManager;
import dev.lydtech.component.framework.extension.TestContainersManager;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestContainersSetupExtension
implements BeforeAllCallback {
    private static final Logger log = LoggerFactory.getLogger(TestContainersSetupExtension.class);
    private static boolean started = false;

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        log.info("Test containers setup extension started.");
        if (!started) {
            started = true;
            DockerClient dockerClient = DockerManager.getDockerClient();
            if (DockerManager.shouldPerformSetup(dockerClient)) {
                TestContainersManager.initialise();
            } else {
                log.info("Main service is running. Skipping TestContainers setup.");
            }
            DockerManager.captureDockerContainerPorts(dockerClient);
        }
        log.info("Test containers setup extension completed.");
    }
}

