/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.debezium;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DebeziumClient {
    private static final Logger log = LoggerFactory.getLogger(DebeziumClient.class);
    private static DebeziumClient instance;
    private static final String CONNECTOR_PATH = "/connectors";
    private RequestSpecification requestSpec;

    private DebeziumClient() {
        String debeziumHost = Optional.ofNullable(System.getProperty("docker.host")).orElse("localhost");
        String debeziumPort = Optional.ofNullable(System.getProperty("debezium.mapped.port")).orElseThrow(() -> new RuntimeException("debezium.mapped.port property not found"));
        String baseUrl = "http://" + debeziumHost + ":" + debeziumPort;
        log.info("Debezium base URL is: " + baseUrl);
        this.requestSpec = new RequestSpecBuilder().setBaseUri(baseUrl).build();
    }

    public static synchronized DebeziumClient getInstance() {
        if (instance == null) {
            instance = new DebeziumClient();
        }
        return instance;
    }

    public String createConnector(String jsonFile) {
        String string;
        FileInputStream in = new FileInputStream(jsonFile);
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = (JsonNode)mapper.readValue((InputStream)in, JsonNode.class);
            String jsonString = mapper.writeValueAsString((Object)jsonNode);
            log.debug("Creating Kafka Connect with config: " + jsonString);
            string = this.postRequest(jsonString, CONNECTOR_PATH, 201);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Failed to create Kafka Connect connector: " + jsonFile, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        ((InputStream)in).close();
        return string;
    }

    public Integer deleteConnector(String connectorName) {
        try {
            return this.deleteRequest("/connectors/" + connectorName);
        }
        catch (Exception e) {
            log.error("Failed to delete Kafka Connect connector: " + connectorName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String postRequest(String request, String path, Integer expectedResponse) {
        String id = (String)((Response)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).body(request).contentType(ContentType.JSON).post(path, new Object[0])).then()).statusCode(expectedResponse.intValue())).extract().response()).body().path("id", new String[0]);
        return id;
    }

    private Integer deleteRequest(String path) {
        return ((Response)RestAssured.given().spec(this.requestSpec).delete(path, new Object[0])).getStatusCode();
    }
}

