/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.elastic;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.util.Optional;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchCtfClient {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchCtfClient.class);
    private static ElasticsearchCtfClient instance;
    private static String baseUrl;

    private ElasticsearchCtfClient() {
        String host = Optional.ofNullable(System.getProperty("docker.host")).orElse("localhost");
        String port = Optional.ofNullable(System.getProperty("elasticsearch.mapped.port")).orElseThrow(() -> new RuntimeException("elasticsearch.mapped.port property not found"));
        baseUrl = "http://" + host + ":" + port;
        log.info("Elasticsearch base URL is: " + baseUrl);
    }

    public static synchronized ElasticsearchCtfClient getInstance() {
        if (instance == null) {
            instance = new ElasticsearchCtfClient();
        }
        return instance;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public ElasticsearchClient getElasticsearchClient() {
        return this.getElasticsearchClient((JsonpMapper)new JacksonJsonpMapper());
    }

    public ElasticsearchClient getElasticsearchClient(JsonpMapper mapper) {
        RestClient restClient = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)baseUrl)}).build();
        RestClientTransport transport = new RestClientTransport(restClient, mapper);
        return new ElasticsearchClient((ElasticsearchTransport)transport);
    }
}

