/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.kafka;

import dev.lydtech.component.framework.client.kafka.KafkaClient;
import dev.lydtech.component.framework.client.kafka.KafkaSchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAvroClient {
    private static final Logger log = LoggerFactory.getLogger(KafkaAvroClient.class);
    private static KafkaAvroClient instance;
    private KafkaProducer avroProducer = this.createProducer();

    private KafkaAvroClient() {
    }

    public static synchronized KafkaAvroClient getInstance() {
        if (instance == null) {
            instance = new KafkaAvroClient();
        }
        return instance;
    }

    public KafkaProducer<Long, String> createProducer() {
        return this.createProducer(null);
    }

    public Consumer createConsumer(String groupId, String topic) {
        Properties config = new Properties();
        config.put("bootstrap.servers", KafkaClient.getInstance().getBrokerUrl());
        config.put("group.id", groupId + "-" + topic);
        config.put("key.deserializer", StringDeserializer.class);
        config.put("value.deserializer", KafkaAvroDeserializer.class);
        config.put("schema.registry.url", KafkaSchemaRegistryClient.getInstance().getSchemaRegistryBaseUrl());
        config.put("auto.register.schemas", (Object)false);
        config.put("specific.avro.reader", (Object)true);
        config.put("auto.offset.reset", "latest");
        config.put("metadata.max.age.ms", (Object)1000);
        KafkaConsumer consumer = new KafkaConsumer(config);
        consumer.subscribe(Collections.singletonList(topic));
        return consumer;
    }

    public <T> List<ConsumerRecord<String, T>> consumeAndAssert(String testName, Consumer consumer, int expectedEventCount, int furtherPolls) throws Exception {
        return KafkaClient.getInstance().consumeAndAssert(testName, consumer, expectedEventCount, furtherPolls);
    }

    public <T> List<ConsumerRecord<String, T>> consumeAndAssert(String testName, Consumer consumer, int expectedEventCount, int furtherPolls, int awaitAtMostSeconds) throws Exception {
        return KafkaClient.getInstance().consumeAndAssert(testName, consumer, expectedEventCount, furtherPolls, awaitAtMostSeconds);
    }

    public KafkaProducer<Long, String> createProducer(Properties additionalConfig) {
        Properties config = new Properties();
        config.put("bootstrap.servers", KafkaClient.getInstance().getBrokerUrl());
        config.put("key.serializer", StringSerializer.class);
        config.put("value.serializer", KafkaAvroSerializer.class);
        config.put("schema.registry.url", KafkaSchemaRegistryClient.getInstance().getSchemaRegistryBaseUrl());
        config.put("auto.register.schemas", (Object)false);
        if (additionalConfig != null && !additionalConfig.isEmpty()) {
            config.putAll((Map<?, ?>)additionalConfig);
        }
        return new KafkaProducer(config);
    }

    public RecordMetadata sendMessage(String topic, String key, Object payload) throws Exception {
        return KafkaClient.getInstance().sendMessage((Producer)this.avroProducer, topic, key, payload, null);
    }

    public RecordMetadata sendMessage(String topic, String key, Object payload, Map<String, String> headers) throws Exception {
        return KafkaClient.getInstance().sendMessage((Producer)this.avroProducer, topic, key, payload, headers);
    }

    public Future<RecordMetadata> sendMessageAsync(String topic, String key, Object payload) {
        return KafkaClient.getInstance().sendMessageAsync((Producer)this.avroProducer, topic, key, payload, null);
    }

    public Future<RecordMetadata> sendMessageAsync(String topic, String key, Object payload, Map<String, String> headers) {
        return KafkaClient.getInstance().sendMessageAsync((Producer)this.avroProducer, topic, key, payload, headers);
    }
}

