/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.client.service;

import io.restassured.builder.RequestSpecBuilder;
import io.restassured.specification.RequestSpecification;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceClient {
    private static final Logger log = LoggerFactory.getLogger(ServiceClient.class);
    private String baseUrl;
    private RequestSpecification requestSpec;
    private static ServiceClient instance;

    private ServiceClient() {
        String serviceHost = Optional.ofNullable(System.getProperty("docker.host")).orElse("localhost");
        String servicePort = Optional.ofNullable(System.getProperty("service.mapped.port")).orElseThrow(() -> new RuntimeException("service.mapped.port property not found"));
        this.baseUrl = "http://" + serviceHost + ":" + servicePort;
        log.info("Service base URL is: " + this.baseUrl);
        this.requestSpec = new RequestSpecBuilder().setBaseUri(this.baseUrl).build();
    }

    public static synchronized ServiceClient getInstance() {
        if (instance == null) {
            instance = new ServiceClient();
        }
        return instance;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public RequestSpecification getRequestSpecification() {
        return this.requestSpec;
    }
}

