/*
 * Decompiled with CFR 0.152.
 */
package dev.lydtech.component.framework.management;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerPort;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import dev.lydtech.component.framework.configuration.TestcontainersConfiguration;
import dev.lydtech.component.framework.resource.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;

public final class DockerManager {
    private static final Logger log = LoggerFactory.getLogger(DockerManager.class);

    public static DockerClient getDockerClient() {
        log.info("Check if services are running");
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost("unix:///var/run/docker.sock").build();
        ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
        return DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
    }

    public static boolean shouldPerformSetup(DockerClient dockerClient) {
        List containers = (List)dockerClient.listContainersCmd().exec();
        boolean mainContainerPresent = containers.stream().filter(container -> Arrays.stream(container.getNames()).anyMatch(name -> name.startsWith("/" + TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-"))).anyMatch(container -> container.getLabels().entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).equals("dev.lydtech.main-container-label") && ((String)entry.getValue()).equals(TestcontainersConfiguration.CONTAINER_MAIN_LABEL)));
        boolean testContainersPresent = containers.stream().anyMatch(container -> Arrays.stream(container.getNames()).anyMatch(name -> name.startsWith("/testcontainers-ryuk")));
        log.info("Current container status: main service with prefix ({}) and label ({}) running: {}, testcontainers running: {}", new Object[]{TestcontainersConfiguration.CONTAINER_NAME_PREFIX, TestcontainersConfiguration.CONTAINER_MAIN_LABEL, mainContainerPresent, testContainersPresent});
        return !mainContainerPresent || testContainersPresent;
    }

    public static void captureDockerContainerPorts(DockerClient dockerClient) {
        log.info("Capturing Docker ports...");
        log.info("Container main label: " + TestcontainersConfiguration.CONTAINER_MAIN_LABEL);
        List serviceContainers = (List)dockerClient.listContainersCmd().withNameFilter(Collections.singletonList(TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-")).withLabelFilter(Collections.singletonMap("dev.lydtech.main-container-label", TestcontainersConfiguration.CONTAINER_MAIN_LABEL)).exec();
        if (serviceContainers.size() <= 0) {
            throw new RuntimeException("Service container not found");
        }
        DockerManager.mapPort(Resource.SERVICE.toString(), TestcontainersConfiguration.SERVICE_PORT, (Container)serviceContainers.get(0));
        DockerManager.findContainerAndMapPort(dockerClient, Resource.POSTGRES.toString(), TestcontainersConfiguration.POSTGRES_ENABLED, TestcontainersConfiguration.POSTGRES_PORT);
        DockerManager.findContainerAndMapPort(dockerClient, Resource.MONGODB.toString(), TestcontainersConfiguration.MONGODB_ENABLED, TestcontainersConfiguration.MONGODB_PORT);
        DockerManager.findContainerAndMapPort(dockerClient, Resource.KAFKA.toString(), TestcontainersConfiguration.KAFKA_ENABLED, TestcontainersConfiguration.KAFKA_PORT);
        DockerManager.findContainerAndMapPort(dockerClient, Resource.DEBEZIUM.toString(), TestcontainersConfiguration.DEBEZIUM_ENABLED, TestcontainersConfiguration.DEBEZIUM_PORT);
        DockerManager.findContainerAndMapPort(dockerClient, Resource.KAFKA_SCHEMA_REGISTRY.toString().replace("_", "."), TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_ENABLED, TestcontainersConfiguration.KAFKA_SCHEMA_REGISTRY_PORT);
        DockerManager.findContainerAndMapPort(dockerClient, Resource.WIREMOCK.toString(), TestcontainersConfiguration.WIREMOCK_ENABLED, TestcontainersConfiguration.WIREMOCK_PORT);
        DockerManager.findContainerAndMapPort(dockerClient, Resource.LOCALSTACK.toString(), TestcontainersConfiguration.LOCALSTACK_ENABLED, TestcontainersConfiguration.LOCALSTACK_PORT);
        DockerManager.findContainerAndMapPort(dockerClient, Resource.CONDUKTORGATEWAY.toString(), TestcontainersConfiguration.CONDUKTOR_GATEWAY_ENABLED, TestcontainersConfiguration.CONDUKTOR_GATEWAY_HTTP_PORT);
        DockerManager.findContainerAndMapPort(dockerClient, Resource.ELASTICSEARCH.toString(), TestcontainersConfiguration.ELASTICSEARCH_ENABLED, TestcontainersConfiguration.ELASTICSEARCH_PORT);
        DockerManager.captureHost();
        log.info("Docker host and ports captured.");
    }

    private static void findContainerAndMapPort(DockerClient dockerClient, String resourceName, boolean enabled, int port) {
        ListContainersCmd listContainersCmd = dockerClient.listContainersCmd();
        String containerName = TestcontainersConfiguration.CONTAINER_NAME_PREFIX + "-" + resourceName;
        log.info("Discovering host and mapping port for container {}", (Object)containerName);
        List containers = (List)listContainersCmd.withNameFilter(Collections.singletonList(containerName)).exec();
        if (containers.size() > 1) {
            containers = containers.stream().filter(container -> Arrays.stream(container.getNames()).anyMatch(n -> n.equals("/" + containerName))).collect(Collectors.toList());
        }
        if (containers.size() == 1) {
            DockerManager.mapPort(resourceName, port, (Container)containers.get(0));
        } else {
            if (enabled) {
                log.error(resourceName + " is enabled but single container is not found - containerName: {} - containers.size(): {} - port: {}", new Object[]{containerName, containers.size(), port});
                throw new RuntimeException(resourceName + " container is not found.");
            }
            log.info(resourceName + " container is not enabled");
        }
    }

    private static void mapPort(String resourceName, int port, Container container) {
        Integer mappedPort = Arrays.stream(container.getPorts()).filter(x -> Objects.equals(x.getPrivatePort(), port)).map(ContainerPort::getPublicPort).findFirst().orElseThrow(() -> new RuntimeException(resourceName + " port not found"));
        log.info(resourceName + " port " + port + " is mapped to " + mappedPort);
        System.setProperty(resourceName + ".mapped.port", mappedPort.toString());
    }

    private static void captureHost() {
        String host = DockerClientFactory.instance().dockerHostIpAddress();
        log.info("Docker host is: " + host);
        System.setProperty("docker.host", host);
    }
}

