/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.actions;

import dev.makth.exceptions.ExecutionException;
import dev.makth.exceptions.NotIterableException;
import dev.makth.exceptions.UnknownVariablesException;
import dev.makth.extensions.StringValue;
import dev.makth.extensions.StringValueKt;
import dev.makth.interfaces.Action;
import dev.makth.interfaces.Iterable;
import dev.makth.interfaces.Value;
import dev.makth.lexers.AlgorithmLexer;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.Variable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u00c6\u0003J-\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006!"}, d2={"Ldev/makth/actions/ForAction;", "Ldev/makth/interfaces/Action;", "identifier", "", "iterable", "Ldev/makth/interfaces/Value;", "actions", "", "<init>", "(Ljava/lang/String;Ldev/makth/interfaces/Value;Ljava/util/List;)V", "getIdentifier", "()Ljava/lang/String;", "getIterable", "()Ldev/makth/interfaces/Value;", "getActions", "()Ljava/util/List;", "execute", "Ldev/makth/resolvables/Context;", "context", "algorithmString", "getAlgorithmString", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "makth"})
@SourceDebugExtension(value={"SMAP\nForAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForAction.kt\ndev/makth/actions/ForAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class ForAction
implements Action {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String identifier;
    @NotNull
    private final Value iterable;
    @NotNull
    private final List<Action> actions;

    public ForAction(@NotNull String identifier, @NotNull Value iterable, @NotNull List<? extends Action> actions) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        this.identifier = identifier;
        this.iterable = iterable;
        this.actions = actions;
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final Value getIterable() {
        return this.iterable;
    }

    @NotNull
    public final List<Action> getActions() {
        return this.actions;
    }

    @Override
    @NotNull
    public Context execute(@NotNull Context context) throws ExecutionException {
        Set<Variable> set;
        Set<Variable> set2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Value evaluatedIterable = this.iterable.compute(context);
        Set<Variable> it = set2 = evaluatedIterable.getVariables();
        boolean bl = false;
        Set<Variable> set3 = set = !((Collection)it).isEmpty() ? set2 : null;
        if (set != null) {
            it = set;
            boolean bl2 = false;
            throw new UnknownVariablesException((Action)this, context, it);
        }
        if (!(evaluatedIterable instanceof Iterable)) {
            throw new NotIterableException((Action)this, context, evaluatedIterable);
        }
        Iterator<Value> iterator = ((Iterable)evaluatedIterable).getIterator();
        Context newContext = context;
        while (iterator.hasNext()) {
            Value value = iterator.next();
            newContext = new Context(MapsKt.plus(newContext.getData(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)this.identifier, (Object)value))), newContext.getOutputs());
            for (Action action : this.actions) {
                newContext = newContext.execute(action);
            }
        }
        return newContext;
    }

    @Override
    @NotNull
    public String getAlgorithmString() {
        StringBuilder builder = new StringBuilder();
        builder.append("for (");
        builder.append(this.identifier);
        builder.append(", ");
        builder.append(this.iterable.getAlgorithmString());
        builder.append(") {");
        for (Action action : this.actions) {
            builder.append("\n");
            builder.append(StringValueKt.getIndentedLines(action.getAlgorithmString()));
        }
        builder.append("\n}");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String component1() {
        return this.identifier;
    }

    @NotNull
    public final Value component2() {
        return this.iterable;
    }

    @NotNull
    public final List<Action> component3() {
        return this.actions;
    }

    @NotNull
    public final ForAction copy(@NotNull String identifier, @NotNull Value iterable, @NotNull List<? extends Action> actions) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        return new ForAction(identifier, iterable, actions);
    }

    public static /* synthetic */ ForAction copy$default(ForAction forAction, String string, Value value, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = forAction.identifier;
        }
        if ((n & 2) != 0) {
            value = forAction.iterable;
        }
        if ((n & 4) != 0) {
            list = forAction.actions;
        }
        return forAction.copy(string, value, list);
    }

    @NotNull
    public String toString() {
        return "ForAction(identifier=" + this.identifier + ", iterable=" + this.iterable + ", actions=" + this.actions + ")";
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = result * 31 + this.iterable.hashCode();
        result = result * 31 + ((Object)this.actions).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ForAction)) {
            return false;
        }
        ForAction forAction = (ForAction)other;
        if (!Intrinsics.areEqual((Object)this.identifier, (Object)forAction.identifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.iterable, (Object)forAction.iterable)) {
            return false;
        }
        return Intrinsics.areEqual(this.actions, forAction.actions);
    }

    @JvmStatic
    @NotNull
    public static final Action handler(@NotNull List<? extends Value> args) {
        return Companion.handler(args);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\t"}, d2={"Ldev/makth/actions/ForAction$Companion;", "", "<init>", "()V", "handler", "Ldev/makth/interfaces/Action;", "args", "", "Ldev/makth/interfaces/Value;", "makth"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Action handler(@NotNull List<? extends Value> args) {
            String string;
            Intrinsics.checkNotNullParameter(args, (String)"args");
            if (((Collection)args).size() != 2) {
                throw new AlgorithmLexer.IncorrectArgumentCountException("for", ((Collection)args).size(), 2);
            }
            Value identifierValue = args.get(0);
            if (identifierValue instanceof Variable) {
                string = ((Variable)identifierValue).getName();
            } else if (identifierValue instanceof StringValue) {
                string = ((StringValue)identifierValue).getValue();
            } else {
                throw new AlgorithmLexer.IncorrectArgumentTypeException("for", identifierValue, (KClass<? extends Value>)Reflection.getOrCreateKotlinClass(Variable.class));
            }
            String identifier = string;
            return new ForAction(identifier, args.get(1), CollectionsKt.emptyList());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

