/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.lexers;

import dev.makth.actions.IfAction;
import dev.makth.actions.PrintAction;
import dev.makth.actions.SetAction;
import dev.makth.actions.WhileAction;
import dev.makth.interfaces.Action;
import dev.makth.interfaces.Value;
import dev.makth.lexers.MathLexer;
import dev.makth.resolvables.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001:\b\u001f !\"#$%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00032\u0018\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0012\u0012\u0004\u0012\u00020\u000e0\u0011J,\u0010\u0016\u001a\u00020\u00002$\u0010\u0017\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0012\u0012\u0004\u0012\u00020\u000e0\u00110\u0010J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\bj\b\u0012\u0004\u0012\u00020\u000e`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u000f\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0012\u0012\u0004\u0012\u00020\u000e0\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ldev/makth/lexers/AlgorithmLexer;", "", "content", "", "<init>", "(Ljava/lang/String;)V", "lastKeyword", "arguments", "Ljava/util/ArrayList;", "Ldev/makth/interfaces/Value;", "Lkotlin/collections/ArrayList;", "i", "", "actions", "Ldev/makth/interfaces/Action;", "keywordHandlers", "", "Lkotlin/Function1;", "", "registerKeyword", "keyword", "handler", "registerKeywords", "keywords", "execute", "createAction", "parseBlock", "", "parseArgs", "parseKeyword", "parseComment", "SyntaxException", "UnknownKeywordException", "UnexpectedKeywordException", "UnexpectedBraceException", "UnexpectedSlashException", "IncorrectArgumentCountException", "IncorrectArgumentTypeException", "Constants", "makth"})
public final class AlgorithmLexer {
    @NotNull
    private final String content;
    @Nullable
    private String lastKeyword;
    @NotNull
    private ArrayList<Value> arguments;
    private int i;
    @NotNull
    private ArrayList<Action> actions;
    @NotNull
    private Map<String, ? extends Function1<? super List<? extends Value>, ? extends Action>> keywordHandlers;

    public AlgorithmLexer(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.content = content;
        this.arguments = new ArrayList();
        this.actions = new ArrayList();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"if", (Object)new Function1<List<? extends Value>, Action>((Object)IfAction.Companion){

            public final Action invoke(List<? extends Value> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((IfAction.Companion)this.receiver).handler(p0);
            }
        }), TuplesKt.to((Object)"print", (Object)new Function1<List<? extends Value>, Action>((Object)PrintAction.Companion){

            public final Action invoke(List<? extends Value> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((PrintAction.Companion)this.receiver).handler(p0);
            }
        }), TuplesKt.to((Object)"set", (Object)new Function1<List<? extends Value>, Action>((Object)SetAction.Companion){

            public final Action invoke(List<? extends Value> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((SetAction.Companion)this.receiver).handler(p0);
            }
        }), TuplesKt.to((Object)"while", (Object)new Function1<List<? extends Value>, Action>((Object)WhileAction.Companion){

            public final Action invoke(List<? extends Value> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((WhileAction.Companion)this.receiver).handler(p0);
            }
        })};
        this.keywordHandlers = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final AlgorithmLexer registerKeyword(@NotNull String keyword, @NotNull Function1<? super List<? extends Value>, ? extends Action> handler) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.keywordHandlers = MapsKt.plus(this.keywordHandlers, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)keyword, handler)));
        return this;
    }

    @NotNull
    public final AlgorithmLexer registerKeywords(@NotNull Map<String, ? extends Function1<? super List<? extends Value>, ? extends Action>> keywords) {
        Intrinsics.checkNotNullParameter(keywords, (String)"keywords");
        this.keywordHandlers = MapsKt.plus(this.keywordHandlers, keywords);
        return this;
    }

    @NotNull
    public final List<Action> execute() throws SyntaxException {
        while (this.i < this.content.length()) {
            char c = this.content.charAt(this.i);
            if (c == '{') {
                this.parseBlock();
            } else if (c == '(') {
                this.parseArgs();
            } else if (c == '/') {
                this.parseComment();
            } else if (StringsKt.contains$default((CharSequence)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_", (char)c, (boolean)false, (int)2, null)) {
                this.parseKeyword();
            }
            c = this.i;
            this.i = c + 1;
        }
        return this.actions;
    }

    private final Action createAction() {
        Object object;
        String string = this.lastKeyword;
        if (string == null) {
            string = "none";
        }
        if ((object = this.keywordHandlers.get(string)) == null || (object = (Action)object.invoke(this.arguments)) == null) {
            Throwable throwable;
            if (this.lastKeyword != null) {
                String string2 = this.lastKeyword;
                if (string2 == null) {
                    string2 = "none";
                }
                throwable = new UnknownKeywordException(string2);
            } else {
                throwable = new UnexpectedBraceException("(");
            }
            throw throwable;
        }
        Object result = object;
        this.arguments.clear();
        this.lastKeyword = null;
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void parseBlock() {
        boolean bl;
        int n = this.i;
        this.i = n + 1;
        StringBuilder subContent = new StringBuilder();
        int count = 0;
        while (this.i < this.content.length() && (this.content.charAt(this.i) != '}' || count != 0)) {
            subContent.append(this.content.charAt(this.i));
            switch (this.content.charAt(this.i)) {
                case '{': {
                    ++count;
                    break;
                }
                case '}': {
                    --count;
                    break;
                }
            }
            int n2 = this.i;
            this.i = n2 + 1;
        }
        String string = subContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        List<Action> block = new AlgorithmLexer(string).registerKeywords(this.keywordHandlers).execute();
        Action lastAction = (Action)CollectionsKt.removeLastOrNull((List)this.actions);
        if (!(lastAction instanceof IfAction)) {
            if (!(lastAction instanceof WhileAction)) throw new UnexpectedBraceException("{");
            bl = this.actions.add(new WhileAction(((WhileAction)lastAction).getCondition(), block));
            return;
        }
        String string2 = this.lastKeyword;
        if (string2 == null) {
            bl = this.actions.add(new IfAction(((IfAction)lastAction).getCondition(), block, null, 4, null));
            return;
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"else")) {
            bl = this.actions.add(new IfAction(((IfAction)lastAction).getCondition(), ((IfAction)lastAction).getActions(), block));
            return;
        }
        String string3 = this.lastKeyword;
        String string4 = string3;
        if (string3 != null) throw new UnexpectedKeywordException(string4);
        string4 = "none";
        throw new UnexpectedKeywordException(string4);
    }

    private final void parseArgs() {
        int n = this.i;
        this.i = n + 1;
        StringBuilder argument = new StringBuilder();
        int count = 0;
        while (this.i < this.content.length() && (this.content.charAt(this.i) != ')' || count != 0)) {
            argument.append(this.content.charAt(this.i));
            switch (this.content.charAt(this.i)) {
                case '(': {
                    ++count;
                    break;
                }
                case ')': {
                    --count;
                    break;
                }
                case ',': {
                    Intrinsics.checkNotNullExpressionValue((Object)argument.deleteCharAt(((CharSequence)argument).length() - 1), (String)"deleteCharAt(...)");
                    String string = argument.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    this.arguments.add(new MathLexer(((Object)StringsKt.trim((CharSequence)string)).toString()).execute(new Context(null, null, 3, null)));
                    StringsKt.clear((StringBuilder)argument);
                }
            }
            int n2 = this.i;
            this.i = n2 + 1;
        }
        String string = argument.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String lastArgument = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (((CharSequence)lastArgument).length() > 0) {
            this.arguments.add(new MathLexer(lastArgument).execute(new Context(null, null, 3, null)));
        }
        this.actions.add(this.createAction());
    }

    private final void parseKeyword() {
        int n;
        StringBuilder keyword = new StringBuilder();
        while (this.i < this.content.length() && StringsKt.contains$default((CharSequence)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_", (char)this.content.charAt(this.i), (boolean)false, (int)2, null)) {
            keyword.append(this.content.charAt(this.i));
            n = this.i;
            this.i = n + 1;
        }
        if (this.lastKeyword != null) {
            String string = keyword.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new UnexpectedKeywordException(string);
        }
        this.lastKeyword = keyword.toString();
        n = this.i;
        this.i = n + -1;
    }

    private final void parseComment() {
        if (this.i + 1 < this.content.length() && this.content.charAt(this.i + 1) == '/') {
            while (this.i < this.content.length() && this.content.charAt(this.i) != '\n') {
                int n = this.i;
                this.i = n + 1;
            }
        } else if (this.i + 1 < this.content.length() && this.content.charAt(this.i + 1) == '*') {
            int n;
            while (this.i + 1 < this.content.length() && (this.content.charAt(this.i) != '*' || this.content.charAt(this.i + 1) != '/')) {
                n = this.i;
                this.i = n + 1;
            }
            n = this.i;
            this.i = n + 1;
        } else {
            throw new UnexpectedSlashException("/");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/makth/lexers/AlgorithmLexer$Constants;", "", "<init>", "()V", "CHARACTERS", "", "makth"})
    public static final class Constants {
        @NotNull
        public static final Constants INSTANCE = new Constants();
        @NotNull
        public static final String CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";

        private Constants() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Ldev/makth/lexers/AlgorithmLexer$IncorrectArgumentCountException;", "Ldev/makth/lexers/AlgorithmLexer$SyntaxException;", "keyword", "", "count", "", "expected", "<init>", "(Ljava/lang/String;II)V", "getKeyword", "()Ljava/lang/String;", "getCount", "()I", "getExpected", "makth"})
    public static class IncorrectArgumentCountException
    extends SyntaxException {
        @NotNull
        private final String keyword;
        private final int count;
        private final int expected;

        public IncorrectArgumentCountException(@NotNull String keyword, int count, int expected) {
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            super("Incorrect argument count for " + keyword + ", got " + count + ", expected " + expected);
            this.keyword = keyword;
            this.count = count;
            this.expected = expected;
        }

        @NotNull
        public final String getKeyword() {
            return this.keyword;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getExpected() {
            return this.expected;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldev/makth/lexers/AlgorithmLexer$IncorrectArgumentTypeException;", "Ldev/makth/lexers/AlgorithmLexer$SyntaxException;", "keyword", "", "value", "Ldev/makth/interfaces/Value;", "expected", "Lkotlin/reflect/KClass;", "<init>", "(Ljava/lang/String;Ldev/makth/interfaces/Value;Lkotlin/reflect/KClass;)V", "getKeyword", "()Ljava/lang/String;", "getValue", "()Ldev/makth/interfaces/Value;", "getExpected", "()Lkotlin/reflect/KClass;", "makth"})
    public static class IncorrectArgumentTypeException
    extends SyntaxException {
        @NotNull
        private final String keyword;
        @NotNull
        private final Value value;
        @NotNull
        private final KClass<? extends Value> expected;

        public IncorrectArgumentTypeException(@NotNull String keyword, @NotNull Value value, @NotNull KClass<? extends Value> expected) {
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(expected, (String)"expected");
            super("Incorrect argument type for " + keyword + ", got " + value.getRawString() + ", expected " + expected);
            this.keyword = keyword;
            this.value = value;
            this.expected = expected;
        }

        @NotNull
        public final String getKeyword() {
            return this.keyword;
        }

        @NotNull
        public final Value getValue() {
            return this.value;
        }

        @NotNull
        public final KClass<? extends Value> getExpected() {
            return this.expected;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ldev/makth/lexers/AlgorithmLexer$SyntaxException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "<init>", "(Ljava/lang/String;)V", "makth"})
    public static class SyntaxException
    extends Exception {
        public SyntaxException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/makth/lexers/AlgorithmLexer$UnexpectedBraceException;", "Ldev/makth/lexers/AlgorithmLexer$SyntaxException;", "character", "", "<init>", "(Ljava/lang/String;)V", "getCharacter", "()Ljava/lang/String;", "makth"})
    public static class UnexpectedBraceException
    extends SyntaxException {
        @NotNull
        private final String character;

        public UnexpectedBraceException(@NotNull String character) {
            Intrinsics.checkNotNullParameter((Object)character, (String)"character");
            super("Unexpected brace: " + character);
            this.character = character;
        }

        @NotNull
        public final String getCharacter() {
            return this.character;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/makth/lexers/AlgorithmLexer$UnexpectedKeywordException;", "Ldev/makth/lexers/AlgorithmLexer$SyntaxException;", "keyword", "", "<init>", "(Ljava/lang/String;)V", "getKeyword", "()Ljava/lang/String;", "makth"})
    public static class UnexpectedKeywordException
    extends SyntaxException {
        @NotNull
        private final String keyword;

        public UnexpectedKeywordException(@NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            super("Unexpected keyword: " + keyword);
            this.keyword = keyword;
        }

        @NotNull
        public final String getKeyword() {
            return this.keyword;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/makth/lexers/AlgorithmLexer$UnexpectedSlashException;", "Ldev/makth/lexers/AlgorithmLexer$SyntaxException;", "character", "", "<init>", "(Ljava/lang/String;)V", "getCharacter", "()Ljava/lang/String;", "makth"})
    public static class UnexpectedSlashException
    extends SyntaxException {
        @NotNull
        private final String character;

        public UnexpectedSlashException(@NotNull String character) {
            Intrinsics.checkNotNullParameter((Object)character, (String)"character");
            super("Unexpected slash: " + character);
            this.character = character;
        }

        @NotNull
        public final String getCharacter() {
            return this.character;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/makth/lexers/AlgorithmLexer$UnknownKeywordException;", "Ldev/makth/lexers/AlgorithmLexer$SyntaxException;", "keyword", "", "<init>", "(Ljava/lang/String;)V", "getKeyword", "()Ljava/lang/String;", "makth"})
    public static class UnknownKeywordException
    extends SyntaxException {
        @NotNull
        private final String keyword;

        public UnknownKeywordException(@NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            super("Unknown keyword: " + keyword);
            this.keyword = keyword;
        }

        @NotNull
        public final String getKeyword() {
            return this.keyword;
        }
    }
}

