/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.numbers.integers;

import dev.makth.extensions.LongExtensionKt;
import dev.makth.interfaces.Value;
import dev.makth.numbers.integers.IntegerFactory;
import dev.makth.numbers.naturals.Natural;
import dev.makth.numbers.naturals.NaturalFactory;
import dev.makth.numbers.rationals.Rational;
import dev.makth.numbers.rationals.RationalFactory;
import dev.makth.numbers.reals.Real;
import dev.makth.numbers.reals.RealFactory;
import dev.makth.numbers.reals.RealImpl;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.Variable;
import dev.makth.sets.matrixes.Matrix;
import dev.makth.sets.matrixes.MatrixFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006 "}, d2={"Ldev/makth/numbers/integers/Integer;", "Ldev/makth/numbers/rationals/Rational;", "longValue", "", "getLongValue", "()J", "numerator", "getNumerator", "()Ldev/makth/numbers/integers/Integer;", "denominator", "Ldev/makth/numbers/naturals/Natural;", "getDenominator", "()Ldev/makth/numbers/naturals/Natural;", "doubleValue", "", "getDoubleValue", "()D", "absoluteValue", "getAbsoluteValue", "rawString", "", "getRawString", "()Ljava/lang/String;", "laTeXString", "getLaTeXString", "sum", "Ldev/makth/interfaces/Value;", "right", "multiply", "divide", "remainder", "raise", "makth"})
public interface Integer
extends Rational {
    public long getLongValue();

    @Override
    @NotNull
    public Integer getNumerator();

    @Override
    @NotNull
    public Natural getDenominator();

    @Override
    public double getDoubleValue();

    @Override
    @NotNull
    public Natural getAbsoluteValue();

    @Override
    @NotNull
    public String getRawString();

    @Override
    @NotNull
    public String getLaTeXString();

    @Override
    @NotNull
    public Value sum(@NotNull Value var1);

    @Override
    @NotNull
    public Value multiply(@NotNull Value var1);

    @Override
    @NotNull
    public Value divide(@NotNull Value var1);

    @Override
    @NotNull
    public Value remainder(@NotNull Value var1);

    @Override
    @NotNull
    public Value raise(@NotNull Value var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nInteger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Integer.kt\ndev/makth/numbers/integers/Integer$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1557#2:177\n1628#2,2:178\n1557#2:180\n1628#2,3:181\n1630#2:184\n*S KotlinDebug\n*F\n+ 1 Integer.kt\ndev/makth/numbers/integers/Integer$DefaultImpls\n*L\n100#1:177\n100#1:178,2\n101#1:180\n101#1:181,3\n100#1:184\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static Integer getNumerator(@NotNull Integer $this) {
            return $this;
        }

        @NotNull
        public static Natural getDenominator(@NotNull Integer $this) {
            return NaturalFactory.INSTANCE.instantiate(1L);
        }

        public static double getDoubleValue(@NotNull Integer $this) {
            return $this.getLongValue();
        }

        @NotNull
        public static Natural getAbsoluteValue(@NotNull Integer $this) {
            return NaturalFactory.INSTANCE.instantiate(Math.abs($this.getLongValue()));
        }

        @NotNull
        public static String getRawString(@NotNull Integer $this) {
            return String.valueOf($this.getLongValue());
        }

        @NotNull
        public static String getLaTeXString(@NotNull Integer $this) {
            return String.valueOf($this.getLongValue());
        }

        @NotNull
        public static Value sum(@NotNull Integer $this, @NotNull Value right) {
            Value newNumerator;
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Integer) {
                return IntegerFactory.INSTANCE.instantiate($this.getLongValue() + ((Integer)right).getLongValue());
            }
            if (right instanceof Rational && (newNumerator = $this.multiply(((Rational)right).getDenominator()).sum(((Rational)right).getNumerator())) instanceof Integer) {
                return RationalFactory.INSTANCE.instantiate((Integer)newNumerator, ((Rational)right).getDenominator());
            }
            return Rational.DefaultImpls.sum($this, right);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Value multiply(@NotNull Integer $this, @NotNull Value right) {
            Object newNumerator;
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Integer) {
                return IntegerFactory.INSTANCE.instantiate($this.getLongValue() * ((Integer)right).getLongValue());
            }
            if (right instanceof Rational && (newNumerator = $this.multiply(((Rational)right).getNumerator())) instanceof Integer) {
                return RationalFactory.INSTANCE.instantiate((Integer)newNumerator, ((Rational)right).getDenominator());
            }
            if (right instanceof Real) {
                return new RealImpl($this.getDoubleValue()).multiply(right);
            }
            if (right instanceof Matrix) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                newNumerator = ((Matrix)right).getRows();
                MatrixFactory matrixFactory = MatrixFactory.INSTANCE;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv2;
                    void rows;
                    List list = (List)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv2 = (Iterable)rows;
                    boolean $i$f$map2 = false;
                    Iterable iterable = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        Value value = (Value)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add($this.multiply((Value)it));
                    }
                    collection.add((List)destination$iv$iv2);
                }
                return matrixFactory.instantiate((List)destination$iv$iv);
            }
            return Rational.DefaultImpls.multiply($this, right);
        }

        @NotNull
        public static Value divide(@NotNull Integer $this, @NotNull Value right) {
            Value newNumerator;
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Integer) {
                return RationalFactory.INSTANCE.instantiate($this, (Integer)right);
            }
            if (right instanceof Rational && (newNumerator = $this.multiply(((Rational)right).getDenominator())) instanceof Integer) {
                return RationalFactory.INSTANCE.instantiate((Integer)newNumerator, ((Rational)right).getNumerator());
            }
            return Rational.DefaultImpls.divide($this, right);
        }

        @NotNull
        public static Value remainder(@NotNull Integer $this, @NotNull Value right) {
            Value newNumerator;
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Integer) {
                return IntegerFactory.INSTANCE.instantiate($this.getLongValue() % ((Integer)right).getLongValue());
            }
            if (right instanceof Rational && (newNumerator = $this.getNumerator().multiply(((Rational)right).getDenominator()).remainder(((Rational)right).getNumerator())) instanceof Integer) {
                return RationalFactory.INSTANCE.instantiate((Integer)newNumerator, ((Rational)right).getDenominator());
            }
            return Rational.DefaultImpls.remainder($this, right);
        }

        @NotNull
        public static Value raise(@NotNull Integer $this, @NotNull Value right) {
            Value firstRaised;
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Integer) {
                return ((Integer)right).getLongValue() < 0L ? (Value)RationalFactory.INSTANCE.instantiate(IntegerFactory.INSTANCE.instantiate(1L), IntegerFactory.INSTANCE.instantiate(LongExtensionKt.pow($this.getLongValue(), -((Integer)right).getLongValue()))) : (Value)IntegerFactory.INSTANCE.instantiate(LongExtensionKt.pow($this.getLongValue(), ((Integer)right).getLongValue()));
            }
            if (right instanceof Rational && (firstRaised = $this.raise(((Rational)right).getNumerator())) instanceof Integer) {
                return ((Integer)firstRaised).getDoubleValue() < 0.0 ? (Value)((((Rational)right).getDenominator().getLongValue() & 1L) == 0L ? RealFactory.INSTANCE.instantiate(Double.NaN) : RealFactory.INSTANCE.instantiate(-LongExtensionKt.nthRoot(-((Integer)firstRaised).getLongValue(), ((Rational)right).getDenominator().getLongValue()))) : (Value)RealFactory.INSTANCE.instantiate(LongExtensionKt.nthRoot(((Integer)firstRaised).getLongValue(), ((Rational)right).getDenominator().getLongValue()));
            }
            return Rational.DefaultImpls.raise($this, right);
        }

        @NotNull
        public static List<Value> getElements(@NotNull Integer $this) {
            return Rational.DefaultImpls.getElements($this);
        }

        @NotNull
        public static Value compute(@NotNull Integer $this, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return Rational.DefaultImpls.compute($this, context);
        }

        @NotNull
        public static Set<Variable> getVariables(@NotNull Integer $this) {
            return Rational.DefaultImpls.getVariables($this);
        }

        public static boolean equals(@NotNull Integer $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Rational.DefaultImpls.equals($this, right);
        }

        public static boolean lessThan(@NotNull Integer $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Rational.DefaultImpls.lessThan($this, right);
        }

        @NotNull
        public static Iterator<Value> getIterator(@NotNull Integer $this) {
            return Rational.DefaultImpls.getIterator($this);
        }

        @NotNull
        public static List<List<Value>> getRows(@NotNull Integer $this) {
            return Rational.DefaultImpls.getRows($this);
        }

        @NotNull
        public static List<List<Value>> getColumns(@NotNull Integer $this) {
            return Rational.DefaultImpls.getColumns($this);
        }

        @NotNull
        public static Matrix transpose(@NotNull Integer $this) {
            return Rational.DefaultImpls.transpose($this);
        }

        @NotNull
        public static String getAlgorithmString(@NotNull Integer $this) {
            return Rational.DefaultImpls.getAlgorithmString($this);
        }

        public static int getMainPrecedence(@NotNull Integer $this) {
            return Rational.DefaultImpls.getMainPrecedence($this);
        }
    }
}

