/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.numbers.rationals;

import dev.makth.interfaces.Value;
import dev.makth.numbers.integers.Integer;
import dev.makth.numbers.integers.IntegerFactory;
import dev.makth.numbers.naturals.Natural;
import dev.makth.numbers.rationals.RationalFactory;
import dev.makth.numbers.reals.Real;
import dev.makth.numbers.reals.RealImpl;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.Variable;
import dev.makth.sets.matrixes.Matrix;
import dev.makth.sets.matrixes.MatrixFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u001e"}, d2={"Ldev/makth/numbers/rationals/Rational;", "Ldev/makth/numbers/reals/Real;", "numerator", "Ldev/makth/numbers/integers/Integer;", "getNumerator", "()Ldev/makth/numbers/integers/Integer;", "denominator", "Ldev/makth/numbers/naturals/Natural;", "getDenominator", "()Ldev/makth/numbers/naturals/Natural;", "doubleValue", "", "getDoubleValue", "()D", "absoluteValue", "getAbsoluteValue", "()Ldev/makth/numbers/rationals/Rational;", "rawString", "", "getRawString", "()Ljava/lang/String;", "laTeXString", "getLaTeXString", "sum", "Ldev/makth/interfaces/Value;", "right", "multiply", "divide", "remainder", "raise", "makth"})
public interface Rational
extends Real {
    @NotNull
    public Integer getNumerator();

    @NotNull
    public Natural getDenominator();

    @Override
    public double getDoubleValue();

    @Override
    @NotNull
    public Rational getAbsoluteValue();

    @Override
    @NotNull
    public String getRawString();

    @Override
    @NotNull
    public String getLaTeXString();

    @Override
    @NotNull
    public Value sum(@NotNull Value var1);

    @Override
    @NotNull
    public Value multiply(@NotNull Value var1);

    @Override
    @NotNull
    public Value divide(@NotNull Value var1);

    @Override
    @NotNull
    public Value remainder(@NotNull Value var1);

    @Override
    @NotNull
    public Value raise(@NotNull Value var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nRational.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rational.kt\ndev/makth/numbers/rationals/Rational$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1557#2:159\n1628#2,2:160\n1557#2:162\n1628#2,3:163\n1630#2:166\n*S KotlinDebug\n*F\n+ 1 Rational.kt\ndev/makth/numbers/rationals/Rational$DefaultImpls\n*L\n93#1:159\n93#1:160,2\n94#1:162\n94#1:163,3\n93#1:166\n*E\n"})
    public static final class DefaultImpls {
        public static double getDoubleValue(@NotNull Rational $this) {
            return $this.getNumerator().getDoubleValue() / $this.getDenominator().getDoubleValue();
        }

        @NotNull
        public static Rational getAbsoluteValue(@NotNull Rational $this) {
            return RationalFactory.INSTANCE.instantiate((Integer)$this.getNumerator().getAbsoluteValue(), $this.getDenominator());
        }

        @NotNull
        public static String getRawString(@NotNull Rational $this) {
            return $this.getNumerator().getRawString() + "/" + $this.getDenominator().getRawString();
        }

        @NotNull
        public static String getLaTeXString(@NotNull Rational $this) {
            return "\\frac{" + $this.getNumerator().getLaTeXString() + "}{" + $this.getDenominator().getLaTeXString() + "}";
        }

        @NotNull
        public static Value sum(@NotNull Rational $this, @NotNull Value right) {
            Value newNumerator;
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Integer && (newNumerator = $this.getNumerator().sum($this.getDenominator().multiply(right))) instanceof Integer) {
                return RationalFactory.INSTANCE.instantiate((Integer)newNumerator, $this.getDenominator());
            }
            if (right instanceof Rational) {
                newNumerator = $this.getNumerator().multiply(((Rational)right).getDenominator()).sum(((Rational)right).getNumerator().multiply($this.getDenominator()));
                Value newDenominator = $this.getDenominator().multiply(((Rational)right).getDenominator());
                if (newNumerator instanceof Integer && newDenominator instanceof Integer) {
                    return RationalFactory.INSTANCE.instantiate((Integer)newNumerator, (Integer)newDenominator);
                }
            }
            return Real.DefaultImpls.sum($this, right);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Value multiply(@NotNull Rational $this, @NotNull Value right) {
            Object newNumerator;
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Integer && (newNumerator = $this.getNumerator().multiply(right)) instanceof Integer) {
                return RationalFactory.INSTANCE.instantiate((Integer)newNumerator, $this.getDenominator());
            }
            if (right instanceof Rational) {
                newNumerator = $this.getNumerator().multiply(((Rational)right).getNumerator());
                Value newDenominator = $this.getDenominator().multiply(((Rational)right).getDenominator());
                if (newNumerator instanceof Integer && newDenominator instanceof Integer) {
                    return RationalFactory.INSTANCE.instantiate((Integer)newNumerator, (Integer)newDenominator);
                }
            }
            if (right instanceof Real) {
                return new RealImpl($this.getDoubleValue()).multiply(right);
            }
            if (right instanceof Matrix) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                newNumerator = ((Matrix)right).getRows();
                MatrixFactory matrixFactory = MatrixFactory.INSTANCE;
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv2;
                    void rows;
                    List list = (List)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv2 = (Iterable)rows;
                    boolean $i$f$map2 = false;
                    Iterable iterable = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        Value value = (Value)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add($this.multiply((Value)it));
                    }
                    collection.add((List)destination$iv$iv2);
                }
                return matrixFactory.instantiate((List)destination$iv$iv);
            }
            return Real.DefaultImpls.multiply($this, right);
        }

        @NotNull
        public static Value divide(@NotNull Rational $this, @NotNull Value right) {
            Value newDenominator;
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Integer && (newDenominator = $this.getDenominator().multiply(right)) instanceof Integer) {
                return RationalFactory.INSTANCE.instantiate($this.getNumerator(), (Integer)newDenominator);
            }
            if (right instanceof Rational) {
                Value newNumerator = $this.getNumerator().multiply(((Rational)right).getDenominator());
                Value newDenominator2 = $this.getDenominator().multiply(((Rational)right).getNumerator());
                if (newNumerator instanceof Integer && newDenominator2 instanceof Integer) {
                    return RationalFactory.INSTANCE.instantiate((Integer)newNumerator, (Integer)newDenominator2);
                }
            }
            return Real.DefaultImpls.divide($this, right);
        }

        @NotNull
        public static Value remainder(@NotNull Rational $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Integer) {
                Value newRight = $this.getDenominator().multiply(right);
                Value newNumerator = $this.getNumerator().remainder(newRight);
                if (newRight instanceof Integer && newNumerator instanceof Integer) {
                    return RationalFactory.INSTANCE.instantiate((Integer)newNumerator, $this.getDenominator());
                }
            }
            if (right instanceof Rational) {
                Value newNumerator = $this.getNumerator().multiply(((Rational)right).getDenominator()).remainder(((Rational)right).getNumerator().multiply($this.getDenominator()));
                Value newDenominator = $this.getDenominator().multiply(((Rational)right).getDenominator());
                if (newNumerator instanceof Integer && newDenominator instanceof Integer) {
                    return RationalFactory.INSTANCE.instantiate((Integer)newNumerator, (Integer)newDenominator);
                }
            }
            return Real.DefaultImpls.remainder($this, right);
        }

        @NotNull
        public static Value raise(@NotNull Rational $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            Natural denominator = $this.getDenominator();
            if (!Intrinsics.areEqual((Object)denominator, (Object)IntegerFactory.INSTANCE.instantiate(1L))) {
                Value newNumerator = $this.getNumerator().raise(right);
                Value newDenominator = denominator.raise(right);
                return newNumerator.divide(newDenominator);
            }
            return Real.DefaultImpls.raise($this, right);
        }

        @NotNull
        public static List<Value> getElements(@NotNull Rational $this) {
            return Real.DefaultImpls.getElements($this);
        }

        @NotNull
        public static Value compute(@NotNull Rational $this, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return Real.DefaultImpls.compute($this, context);
        }

        @NotNull
        public static Set<Variable> getVariables(@NotNull Rational $this) {
            return Real.DefaultImpls.getVariables($this);
        }

        public static boolean equals(@NotNull Rational $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Real.DefaultImpls.equals($this, right);
        }

        public static boolean lessThan(@NotNull Rational $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Real.DefaultImpls.lessThan($this, right);
        }

        @NotNull
        public static Iterator<Value> getIterator(@NotNull Rational $this) {
            return Real.DefaultImpls.getIterator($this);
        }

        @NotNull
        public static List<List<Value>> getRows(@NotNull Rational $this) {
            return Real.DefaultImpls.getRows($this);
        }

        @NotNull
        public static List<List<Value>> getColumns(@NotNull Rational $this) {
            return Real.DefaultImpls.getColumns($this);
        }

        @NotNull
        public static Matrix transpose(@NotNull Rational $this) {
            return Real.DefaultImpls.transpose($this);
        }

        @NotNull
        public static String getAlgorithmString(@NotNull Rational $this) {
            return Real.DefaultImpls.getAlgorithmString($this);
        }

        public static int getMainPrecedence(@NotNull Rational $this) {
            return Real.DefaultImpls.getMainPrecedence($this);
        }
    }
}

