/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.numbers.rationals;

import dev.makth.extensions.LongExtensionKt;
import dev.makth.numbers.integers.Integer;
import dev.makth.numbers.integers.IntegerFactory;
import dev.makth.numbers.naturals.Natural;
import dev.makth.numbers.naturals.NaturalFactory;
import dev.makth.numbers.rationals.Rational;
import dev.makth.numbers.rationals.RationalImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Ldev/makth/numbers/rationals/RationalFactory;", "", "<init>", "()V", "instantiate", "Ldev/makth/numbers/rationals/Rational;", "numerator", "Ldev/makth/numbers/integers/Integer;", "denominator", "Ldev/makth/numbers/naturals/Natural;", "", "makth"})
public final class RationalFactory {
    @NotNull
    public static final RationalFactory INSTANCE = new RationalFactory();

    private RationalFactory() {
    }

    @NotNull
    public final Rational instantiate(@NotNull Integer numerator, @NotNull Natural denominator) {
        Rational rational;
        Intrinsics.checkNotNullParameter((Object)numerator, (String)"numerator");
        Intrinsics.checkNotNullParameter((Object)denominator, (String)"denominator");
        long gcd = LongExtensionKt.gcd(numerator.getLongValue(), denominator.getLongValue());
        if (gcd != 1L) {
            long newNumeratorValue = numerator.getLongValue() / gcd;
            long newDenominatorValue = denominator.getLongValue() / gcd;
            rational = newDenominatorValue == 1L ? (Rational)IntegerFactory.INSTANCE.instantiate(newNumeratorValue) : (Rational)new RationalImpl(IntegerFactory.INSTANCE.instantiate(newNumeratorValue), NaturalFactory.INSTANCE.instantiate(newDenominatorValue));
        } else {
            rational = new RationalImpl(numerator, denominator);
        }
        return rational;
    }

    @NotNull
    public final Rational instantiate(@NotNull Integer numerator, @NotNull Integer denominator) {
        Intrinsics.checkNotNullParameter((Object)numerator, (String)"numerator");
        Intrinsics.checkNotNullParameter((Object)denominator, (String)"denominator");
        return denominator.getLongValue() < 0L ? this.instantiate(IntegerFactory.INSTANCE.instantiate((long)-1 * numerator.getLongValue()), denominator.getAbsoluteValue()) : this.instantiate(numerator, denominator.getAbsoluteValue());
    }

    @NotNull
    public final Rational instantiate(long numerator, long denominator) {
        return this.instantiate(IntegerFactory.INSTANCE.instantiate(numerator), IntegerFactory.INSTANCE.instantiate(denominator));
    }
}

