/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.numbers.rationals;

import dev.makth.interfaces.Value;
import dev.makth.numbers.integers.Integer;
import dev.makth.numbers.naturals.Natural;
import dev.makth.numbers.rationals.Rational;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.Variable;
import dev.makth.sets.matrixes.Matrix;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ldev/makth/numbers/rationals/RationalImpl;", "Ldev/makth/numbers/rationals/Rational;", "numerator", "Ldev/makth/numbers/integers/Integer;", "denominator", "Ldev/makth/numbers/naturals/Natural;", "<init>", "(Ldev/makth/numbers/integers/Integer;Ldev/makth/numbers/naturals/Natural;)V", "getNumerator", "()Ldev/makth/numbers/integers/Integer;", "getDenominator", "()Ldev/makth/numbers/naturals/Natural;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "makth"})
public final class RationalImpl
implements Rational {
    @NotNull
    private final Integer numerator;
    @NotNull
    private final Natural denominator;

    public RationalImpl(@NotNull Integer numerator, @NotNull Natural denominator) {
        Intrinsics.checkNotNullParameter((Object)numerator, (String)"numerator");
        Intrinsics.checkNotNullParameter((Object)denominator, (String)"denominator");
        this.numerator = numerator;
        this.denominator = denominator;
        if (this.getDenominator().getLongValue() == 0L) {
            throw new IllegalArgumentException("Denominator cannot be null!");
        }
    }

    @Override
    @NotNull
    public Integer getNumerator() {
        return this.numerator;
    }

    @Override
    @NotNull
    public Natural getDenominator() {
        return this.denominator;
    }

    @NotNull
    public final Integer component1() {
        return this.numerator;
    }

    @NotNull
    public final Natural component2() {
        return this.denominator;
    }

    @NotNull
    public final RationalImpl copy(@NotNull Integer numerator, @NotNull Natural denominator) {
        Intrinsics.checkNotNullParameter((Object)numerator, (String)"numerator");
        Intrinsics.checkNotNullParameter((Object)denominator, (String)"denominator");
        return new RationalImpl(numerator, denominator);
    }

    public static /* synthetic */ RationalImpl copy$default(RationalImpl rationalImpl, Integer integer, Natural natural, int n, Object object) {
        if ((n & 1) != 0) {
            integer = rationalImpl.numerator;
        }
        if ((n & 2) != 0) {
            natural = rationalImpl.denominator;
        }
        return rationalImpl.copy(integer, natural);
    }

    @NotNull
    public String toString() {
        return "RationalImpl(numerator=" + this.numerator + ", denominator=" + this.denominator + ")";
    }

    public int hashCode() {
        int result = this.numerator.hashCode();
        result = result * 31 + this.denominator.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RationalImpl)) {
            return false;
        }
        RationalImpl rationalImpl = (RationalImpl)other;
        if (!Intrinsics.areEqual((Object)this.numerator, (Object)rationalImpl.numerator)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.denominator, (Object)rationalImpl.denominator);
    }

    @Override
    public double getDoubleValue() {
        return Rational.DefaultImpls.getDoubleValue(this);
    }

    @Override
    @NotNull
    public Rational getAbsoluteValue() {
        return Rational.DefaultImpls.getAbsoluteValue(this);
    }

    @Override
    @NotNull
    public String getRawString() {
        return Rational.DefaultImpls.getRawString(this);
    }

    @Override
    @NotNull
    public String getLaTeXString() {
        return Rational.DefaultImpls.getLaTeXString(this);
    }

    @Override
    @NotNull
    public Value sum(@NotNull Value right) {
        return Rational.DefaultImpls.sum(this, right);
    }

    @Override
    @NotNull
    public Value multiply(@NotNull Value right) {
        return Rational.DefaultImpls.multiply(this, right);
    }

    @Override
    @NotNull
    public Value divide(@NotNull Value right) {
        return Rational.DefaultImpls.divide(this, right);
    }

    @Override
    @NotNull
    public Value remainder(@NotNull Value right) {
        return Rational.DefaultImpls.remainder(this, right);
    }

    @Override
    @NotNull
    public Value raise(@NotNull Value right) {
        return Rational.DefaultImpls.raise(this, right);
    }

    @Override
    @NotNull
    public List<Value> getElements() {
        return Rational.DefaultImpls.getElements(this);
    }

    @Override
    @NotNull
    public Value compute(@NotNull Context context) {
        return Rational.DefaultImpls.compute(this, context);
    }

    @Override
    @NotNull
    public Set<Variable> getVariables() {
        return Rational.DefaultImpls.getVariables(this);
    }

    @Override
    public boolean equals(@NotNull Value right) {
        return Rational.DefaultImpls.equals(this, right);
    }

    @Override
    public boolean lessThan(@NotNull Value right) {
        return Rational.DefaultImpls.lessThan(this, right);
    }

    @Override
    @NotNull
    public Iterator<Value> getIterator() {
        return Rational.DefaultImpls.getIterator(this);
    }

    @Override
    @NotNull
    public List<List<Value>> getRows() {
        return Rational.DefaultImpls.getRows(this);
    }

    @Override
    @NotNull
    public List<List<Value>> getColumns() {
        return Rational.DefaultImpls.getColumns(this);
    }

    @Override
    @NotNull
    public Matrix transpose() {
        return Rational.DefaultImpls.transpose(this);
    }

    @Override
    @NotNull
    public String getAlgorithmString() {
        return Rational.DefaultImpls.getAlgorithmString(this);
    }

    @Override
    public int getMainPrecedence() {
        return Rational.DefaultImpls.getMainPrecedence(this);
    }
}

