/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.numbers.reals;

import dev.makth.interfaces.Value;
import dev.makth.numbers.reals.RealFactory;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.Variable;
import dev.makth.sets.matrixes.Matrix;
import dev.makth.sets.matrixes.MatrixFactory;
import dev.makth.sets.vectors.Vector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Ldev/makth/numbers/reals/Real;", "Ldev/makth/sets/vectors/Vector;", "doubleValue", "", "getDoubleValue", "()D", "absoluteValue", "getAbsoluteValue", "()Ldev/makth/numbers/reals/Real;", "elements", "", "Ldev/makth/interfaces/Value;", "getElements", "()Ljava/util/List;", "rawString", "", "getRawString", "()Ljava/lang/String;", "laTeXString", "getLaTeXString", "compute", "context", "Ldev/makth/resolvables/Context;", "variables", "", "Ldev/makth/resolvables/variables/Variable;", "getVariables", "()Ljava/util/Set;", "equals", "", "right", "lessThan", "sum", "multiply", "divide", "remainder", "raise", "makth"})
public interface Real
extends Vector {
    public double getDoubleValue();

    @NotNull
    public Real getAbsoluteValue();

    @Override
    @NotNull
    public List<Value> getElements();

    @Override
    @NotNull
    public String getRawString();

    @Override
    @NotNull
    public String getLaTeXString();

    @Override
    @NotNull
    public Value compute(@NotNull Context var1);

    @Override
    @NotNull
    public Set<Variable> getVariables();

    @Override
    public boolean equals(@NotNull Value var1);

    @Override
    public boolean lessThan(@NotNull Value var1);

    @Override
    @NotNull
    public Value sum(@NotNull Value var1);

    @Override
    @NotNull
    public Value multiply(@NotNull Value var1);

    @Override
    @NotNull
    public Value divide(@NotNull Value var1);

    @Override
    @NotNull
    public Value remainder(@NotNull Value var1);

    @Override
    @NotNull
    public Value raise(@NotNull Value var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nReal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Real.kt\ndev/makth/numbers/reals/Real$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1557#2:118\n1628#2,2:119\n1557#2:121\n1628#2,3:122\n1630#2:125\n*S KotlinDebug\n*F\n+ 1 Real.kt\ndev/makth/numbers/reals/Real$DefaultImpls\n*L\n88#1:118\n88#1:119,2\n89#1:121\n89#1:122,3\n88#1:125\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static Real getAbsoluteValue(@NotNull Real $this) {
            return RealFactory.INSTANCE.instantiate(Math.abs($this.getDoubleValue()));
        }

        @NotNull
        public static List<Value> getElements(@NotNull Real $this) {
            return CollectionsKt.listOf((Object)$this);
        }

        @NotNull
        public static String getRawString(@NotNull Real $this) {
            return String.valueOf($this.getDoubleValue());
        }

        @NotNull
        public static String getLaTeXString(@NotNull Real $this) {
            return String.valueOf($this.getDoubleValue());
        }

        @NotNull
        public static Value compute(@NotNull Real $this, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return $this;
        }

        @NotNull
        public static Set<Variable> getVariables(@NotNull Real $this) {
            return SetsKt.emptySet();
        }

        public static boolean equals(@NotNull Real $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Real) {
                return $this.getDoubleValue() == ((Real)right).getDoubleValue();
            }
            return Vector.DefaultImpls.equals($this, right);
        }

        public static boolean lessThan(@NotNull Real $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Real) {
                return $this.getDoubleValue() < ((Real)right).getDoubleValue();
            }
            return Vector.DefaultImpls.lessThan($this, right);
        }

        @NotNull
        public static Value sum(@NotNull Real $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Real) {
                return RealFactory.INSTANCE.instantiate($this.getDoubleValue() + ((Real)right).getDoubleValue());
            }
            return Vector.DefaultImpls.sum($this, right);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Value multiply(@NotNull Real $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Real) {
                return RealFactory.INSTANCE.instantiate($this.getDoubleValue() * ((Real)right).getDoubleValue());
            }
            if (right instanceof Matrix) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = ((Matrix)right).getRows();
                MatrixFactory matrixFactory = MatrixFactory.INSTANCE;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv2;
                    void rows;
                    List list = (List)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv2 = (Iterable)rows;
                    boolean $i$f$map2 = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        Value value = (Value)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add($this.multiply((Value)it));
                    }
                    collection.add((List)destination$iv$iv2);
                }
                return matrixFactory.instantiate((List)destination$iv$iv);
            }
            return Vector.DefaultImpls.multiply($this, right);
        }

        @NotNull
        public static Value divide(@NotNull Real $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Real) {
                return RealFactory.INSTANCE.instantiate($this.getDoubleValue() / ((Real)right).getDoubleValue());
            }
            return Vector.DefaultImpls.divide($this, right);
        }

        @NotNull
        public static Value remainder(@NotNull Real $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Real) {
                return RealFactory.INSTANCE.instantiate($this.getDoubleValue() % ((Real)right).getDoubleValue());
            }
            return Vector.DefaultImpls.remainder($this, right);
        }

        @NotNull
        public static Value raise(@NotNull Real $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Real) {
                return RealFactory.INSTANCE.instantiate(Math.pow($this.getDoubleValue(), ((Real)right).getDoubleValue()));
            }
            return Vector.DefaultImpls.raise($this, right);
        }

        @NotNull
        public static Iterator<Value> getIterator(@NotNull Real $this) {
            return Vector.DefaultImpls.getIterator($this);
        }

        @NotNull
        public static List<List<Value>> getRows(@NotNull Real $this) {
            return Vector.DefaultImpls.getRows($this);
        }

        @NotNull
        public static List<List<Value>> getColumns(@NotNull Real $this) {
            return Vector.DefaultImpls.getColumns($this);
        }

        @NotNull
        public static Matrix transpose(@NotNull Real $this) {
            return Vector.DefaultImpls.transpose($this);
        }

        @NotNull
        public static String getAlgorithmString(@NotNull Real $this) {
            return Vector.DefaultImpls.getAlgorithmString($this);
        }

        public static int getMainPrecedence(@NotNull Real $this) {
            return Vector.DefaultImpls.getMainPrecedence($this);
        }
    }
}

