/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.operations;

import dev.makth.interfaces.Value;
import dev.makth.lexers.AlgorithmLexer;
import dev.makth.lexers.MathLexer;
import dev.makth.numbers.integers.IntegerFactory;
import dev.makth.operations.Equality;
import dev.makth.operations.Exponentiation;
import dev.makth.operations.Product;
import dev.makth.operations.Quotient;
import dev.makth.operations.Remainder;
import dev.makth.operations.Sum;
import dev.makth.sets.matrixes.Matrix;
import dev.makth.sets.matrixes.MatrixFactory;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a8\u0006\u0011"}, d2={"Ldev/makth/operations/OperationFactory;", "", "<init>", "()V", "initialize", "Ldev/makth/interfaces/Value;", "operator", "", "left", "right", "getPrecedence", "", "operation", "getPrecedence$makth", "createHorizontalMatrix", "Ldev/makth/sets/matrixes/Matrix;", "createVerticalMatrix", "makth"})
public final class OperationFactory {
    @NotNull
    public static final OperationFactory INSTANCE = new OperationFactory();

    private OperationFactory() {
    }

    @NotNull
    public final Value initialize(@NotNull String operator, @NotNull Value left, @NotNull Value right) throws AlgorithmLexer.SyntaxException {
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return switch (operator) {
            case "+" -> new Sum(left, right);
            case "-" -> new Sum(left, new Product(IntegerFactory.INSTANCE.instantiate(-1L), right));
            case "*" -> new Product(left, right);
            case "/" -> new Quotient(left, right);
            case "%" -> new Remainder(left, right);
            case "^" -> new Exponentiation(left, right);
            case "=" -> new Equality(left, right, null, 4, null);
            case "!=" -> new Equality(left, right, Equality.Operator.NotEquals);
            case "<" -> new Equality(left, right, Equality.Operator.LessThan);
            case ">" -> new Equality(left, right, Equality.Operator.GreaterThan);
            case "<=" -> new Equality(left, right, Equality.Operator.LessThanOrEquals);
            case ">=" -> new Equality(left, right, Equality.Operator.GreaterThanOrEquals);
            case "," -> this.createHorizontalMatrix(left, right);
            case ";" -> this.createVerticalMatrix(left, right);
            default -> throw new MathLexer.UnknownOperatorException(operator);
        };
    }

    public final int getPrecedence$makth(@NotNull String operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return switch (operation) {
            case "^" -> 5;
            case "%", "*", "/" -> 4;
            case "+", "-" -> 3;
            case "," -> 2;
            case ";" -> 1;
            default -> 0;
        };
    }

    private final Matrix createHorizontalMatrix(Value left, Value right) {
        Matrix matrix;
        if (left instanceof Matrix && ((Collection)((Matrix)left).getRows()).size() == 1) {
            matrix = MatrixFactory.INSTANCE.instantiate(CollectionsKt.listOf((Object)CollectionsKt.plus((Collection)((Collection)CollectionsKt.first(((Matrix)left).getRows())), (Object)right)));
        } else {
            Object[] objectArray = new List[]{CollectionsKt.listOf((Object)left), CollectionsKt.listOf((Object)right)};
            matrix = MatrixFactory.INSTANCE.instantiate(CollectionsKt.listOf((Object[])objectArray));
        }
        return matrix;
    }

    private final Matrix createVerticalMatrix(Value left, Value right) {
        Matrix matrix;
        if (left instanceof Matrix && right instanceof Matrix && ((Collection)((Matrix)right).getRows()).size() == 1) {
            matrix = MatrixFactory.INSTANCE.instantiate(CollectionsKt.plus((Collection)((Matrix)left).getRows(), (Iterable)((Matrix)right).getRows()));
        } else {
            Object[] objectArray = new List[]{CollectionsKt.listOf((Object)left), CollectionsKt.listOf((Object)right)};
            matrix = MatrixFactory.INSTANCE.instantiate(CollectionsKt.listOf((Object[])objectArray));
        }
        return matrix;
    }
}

