/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.operations;

import dev.makth.extensions.UnsupportedOperationExceptionExtensionKt;
import dev.makth.interfaces.Value;
import dev.makth.operations.Operation;
import dev.makth.operations.OperationFactory;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.Variable;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u0019H\u00d6\u0001J\t\u0010$\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Ldev/makth/operations/Quotient;", "Ldev/makth/operations/Operation;", "left", "Ldev/makth/interfaces/Value;", "right", "<init>", "(Ldev/makth/interfaces/Value;Ldev/makth/interfaces/Value;)V", "getLeft", "()Ldev/makth/interfaces/Value;", "getRight", "compute", "context", "Ldev/makth/resolvables/Context;", "rawString", "", "getRawString", "()Ljava/lang/String;", "laTeXString", "getLaTeXString", "variables", "", "Ldev/makth/resolvables/variables/Variable;", "getVariables", "()Ljava/util/Set;", "mainPrecedence", "", "getMainPrecedence", "()I", "equals", "", "component1", "component2", "copy", "other", "", "hashCode", "toString", "makth"})
public final class Quotient
implements Operation {
    @NotNull
    private final Value left;
    @NotNull
    private final Value right;

    public Quotient(@NotNull Value left, @NotNull Value right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        this.left = left;
        this.right = right;
    }

    @NotNull
    public final Value getLeft() {
        return this.left;
    }

    @NotNull
    public final Value getRight() {
        return this.right;
    }

    @Override
    @NotNull
    public Value compute(@NotNull Context context) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Value left = this.left.compute(context);
        Value right = this.right.compute(context);
        try {
            value = left.divide(right);
        }
        catch (UnsupportedOperationException e) {
            value = new Quotient(left, right);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getRawString() {
        void var3_1;
        String it = this.left.getRawString();
        boolean bl = false;
        String leftRawString = this.left.getMainPrecedence() < this.getMainPrecedence() ? "(" + it + ")" : var3_1;
        String it2 = this.right.getRawString();
        boolean bl2 = false;
        Object rightRawString = this.right.getMainPrecedence() < this.getMainPrecedence() ? "(" + it2 + ")" : it2;
        return leftRawString + " / " + (String)rightRawString;
    }

    @Override
    @NotNull
    public String getLaTeXString() {
        return "\\frac{" + this.left.getLaTeXString() + "}{" + this.right.getLaTeXString() + "}";
    }

    @Override
    @NotNull
    public Set<Variable> getVariables() {
        return SetsKt.plus(this.left.getVariables(), (Iterable)this.right.getVariables());
    }

    @Override
    public int getMainPrecedence() {
        return OperationFactory.INSTANCE.getPrecedence$makth("/");
    }

    @Override
    public boolean equals(@NotNull Value right) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        if (right instanceof Quotient) {
            Function0[] function0Array = new Function0[]{() -> Quotient.equals$lambda$2(this, right), () -> Quotient.equals$lambda$3(this, right)};
            return UnsupportedOperationExceptionExtensionKt.orOrThrowUnsupportedOperationException(function0Array);
        }
        return Operation.DefaultImpls.equals(this, right);
    }

    @NotNull
    public final Value component1() {
        return this.left;
    }

    @NotNull
    public final Value component2() {
        return this.right;
    }

    @NotNull
    public final Quotient copy(@NotNull Value left, @NotNull Value right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new Quotient(left, right);
    }

    public static /* synthetic */ Quotient copy$default(Quotient quotient, Value value, Value value2, int n, Object object) {
        if ((n & 1) != 0) {
            value = quotient.left;
        }
        if ((n & 2) != 0) {
            value2 = quotient.right;
        }
        return quotient.copy(value, value2);
    }

    @NotNull
    public String toString() {
        return "Quotient(left=" + this.left + ", right=" + this.right + ")";
    }

    public int hashCode() {
        int result = this.left.hashCode();
        result = result * 31 + this.right.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Quotient)) {
            return false;
        }
        Quotient quotient = (Quotient)other;
        if (!Intrinsics.areEqual((Object)this.left, (Object)quotient.left)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.right, (Object)quotient.right);
    }

    @Override
    @NotNull
    public String getAlgorithmString() {
        return Operation.DefaultImpls.getAlgorithmString(this);
    }

    @Override
    public boolean lessThan(@NotNull Value right) {
        return Operation.DefaultImpls.lessThan(this, right);
    }

    @Override
    @NotNull
    public Value sum(@NotNull Value right) {
        return Operation.DefaultImpls.sum(this, right);
    }

    @Override
    @NotNull
    public Value multiply(@NotNull Value right) {
        return Operation.DefaultImpls.multiply(this, right);
    }

    @Override
    @NotNull
    public Value divide(@NotNull Value right) {
        return Operation.DefaultImpls.divide(this, right);
    }

    @Override
    @NotNull
    public Value remainder(@NotNull Value right) {
        return Operation.DefaultImpls.remainder(this, right);
    }

    @Override
    @NotNull
    public Value raise(@NotNull Value right) {
        return Operation.DefaultImpls.raise(this, right);
    }

    private static final boolean equals$lambda$2(Quotient this$0, Value $right) {
        return this$0.left.equals(((Quotient)$right).left) && this$0.right.equals(((Quotient)$right).right);
    }

    private static final boolean equals$lambda$3(Quotient this$0, Value $right) {
        return this$0.left.equals(this$0.right) && ((Quotient)$right).left.equals(((Quotient)$right).right);
    }
}

