/*
 * Decompiled with CFR 0.152.
 */
package dev.makth.sets.matrixes;

import dev.makth.interfaces.Iterable;
import dev.makth.interfaces.Value;
import dev.makth.resolvables.Context;
import dev.makth.resolvables.variables.Variable;
import dev.makth.sets.matrixes.MatrixFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\bg\u0018\u00002\u00020\u0001J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016R\u001e\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Ldev/makth/sets/matrixes/Matrix;", "Ldev/makth/interfaces/Iterable;", "rows", "", "Ldev/makth/interfaces/Value;", "getRows", "()Ljava/util/List;", "columns", "getColumns", "iterator", "", "getIterator", "()Ljava/util/Iterator;", "compute", "context", "Ldev/makth/resolvables/Context;", "rawString", "", "getRawString", "()Ljava/lang/String;", "laTeXString", "getLaTeXString", "variables", "", "Ldev/makth/resolvables/variables/Variable;", "getVariables", "()Ljava/util/Set;", "transpose", "equals", "", "right", "sum", "multiply", "makth"})
public interface Matrix
extends Iterable {
    @NotNull
    public List<List<Value>> getRows();

    @NotNull
    public List<List<Value>> getColumns();

    @Override
    @NotNull
    public Iterator<Value> getIterator();

    @Override
    @NotNull
    public Value compute(@NotNull Context var1);

    @Override
    @NotNull
    public String getRawString();

    @Override
    @NotNull
    public String getLaTeXString();

    @Override
    @NotNull
    public Set<Variable> getVariables();

    @NotNull
    public Matrix transpose();

    @Override
    public boolean equals(@NotNull Value var1);

    @Override
    @NotNull
    public Value sum(@NotNull Value var1);

    @Override
    @NotNull
    public Value multiply(@NotNull Value var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\ndev/makth/sets/matrixes/Matrix$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1557#2:111\n1628#2,3:112\n1557#2:115\n1628#2,2:116\n1557#2:118\n1628#2,3:119\n1630#2:122\n1368#2:123\n1454#2,2:124\n1368#2:126\n1454#2,5:127\n1456#2,3:132\n1734#2,2:135\n1734#2,3:137\n1736#2:140\n1557#2:141\n1628#2,2:142\n1557#2:144\n1628#2,3:145\n1630#2:148\n1557#2:149\n1628#2,2:150\n1557#2:152\n1628#2,2:153\n1557#2:155\n1628#2,3:156\n2669#2,7:159\n1630#2:166\n1630#2:167\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\ndev/makth/sets/matrixes/Matrix$DefaultImpls\n*L\n31#1:111\n31#1:112,3\n39#1:115\n39#1:116,2\n40#1:118\n40#1:119,3\n39#1:122\n60#1:123\n60#1:124,2\n61#1:126\n61#1:127,5\n60#1:132,3\n74#1:135,2\n75#1:137,3\n74#1:140\n86#1:141\n86#1:142,2\n87#1:144\n87#1:145,3\n86#1:148\n98#1:149\n98#1:150,2\n99#1:152\n99#1:153,2\n100#1:155\n100#1:156,3\n102#1:159,7\n99#1:166\n98#1:167\n*E\n"})
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Iterator<Value> getIterator(@NotNull Matrix $this) {
            void $this$mapTo$iv$iv;
            java.lang.Iterable $this$map$iv = $this.getRows();
            boolean $i$f$map = false;
            java.lang.Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((java.lang.Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MatrixFactory.INSTANCE.instantiate(CollectionsKt.listOf((Object)it)));
            }
            return ((List)destination$iv$iv).iterator();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Value compute(@NotNull Matrix $this, @NotNull Context context) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            java.lang.Iterable iterable = $this.getRows();
            MatrixFactory matrixFactory = MatrixFactory.INSTANCE;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((java.lang.Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void row;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                java.lang.Iterable $this$map$iv2 = (java.lang.Iterable)row;
                boolean $i$f$map2 = false;
                java.lang.Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((java.lang.Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    Value value = (Value)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(it.compute(context));
                }
                collection.add((List)destination$iv$iv2);
            }
            return matrixFactory.instantiate((List)destination$iv$iv);
        }

        @NotNull
        public static String getRawString(@NotNull Matrix $this) {
            return CollectionsKt.joinToString$default((java.lang.Iterable)$this.getRows(), (CharSequence)"; ", (CharSequence)"(", (CharSequence)")", (int)0, null, DefaultImpls::_get_rawString_$lambda$4, (int)24, null);
        }

        @NotNull
        public static String getLaTeXString(@NotNull Matrix $this) {
            return CollectionsKt.joinToString$default((java.lang.Iterable)$this.getRows(), (CharSequence)" \\\\ ", (CharSequence)"\\begin{bmatrix} ", (CharSequence)" \\end{bmatrix}", (int)0, null, DefaultImpls::_get_laTeXString_$lambda$6, (int)24, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Set<Variable> getVariables(@NotNull Matrix $this) {
            void $this$flatMapTo$iv$iv;
            java.lang.Iterable $this$flatMap$iv = $this.getRows();
            boolean $i$f$flatMap = false;
            java.lang.Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$flatMapTo$iv$iv2;
                List row = (List)element$iv$iv;
                boolean bl = false;
                java.lang.Iterable $this$flatMap$iv2 = row;
                boolean $i$f$flatMap2 = false;
                java.lang.Iterable iterable2 = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                    Value it = (Value)element$iv$iv2;
                    boolean bl2 = false;
                    java.lang.Iterable list$iv$iv = it.getVariables();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (java.lang.Iterable)list$iv$iv);
                }
                java.lang.Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (java.lang.Iterable)list$iv$iv);
            }
            return CollectionsKt.toSet((java.lang.Iterable)((List)destination$iv$iv));
        }

        @NotNull
        public static Matrix transpose(@NotNull Matrix $this) {
            return MatrixFactory.INSTANCE.instantiate($this.getColumns());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean equals(@NotNull Matrix $this, @NotNull Value right) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (!(right instanceof Matrix)) return Iterable.DefaultImpls.equals($this, right);
            if (((Collection)$this.getRows()).size() != ((Collection)((Matrix)right).getRows()).size()) return false;
            if (((Collection)$this.getColumns()).size() != ((Collection)((Matrix)right).getColumns()).size()) return false;
            java.lang.Iterable $this$all$iv = CollectionsKt.zip((java.lang.Iterable)$this.getRows(), (java.lang.Iterable)((Matrix)right).getRows());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                Pair rows = (Pair)element$iv;
                boolean bl2 = false;
                java.lang.Iterable $this$all$iv2 = CollectionsKt.zip((java.lang.Iterable)((java.lang.Iterable)rows.getFirst()), (java.lang.Iterable)((java.lang.Iterable)rows.getSecond()));
                boolean $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl = true;
                    continue;
                }
                for (Object element$iv2 : $this$all$iv2) {
                    Pair it = (Pair)element$iv2;
                    boolean bl3 = false;
                    if (((Value)it.getFirst()).equals((Value)it.getSecond())) continue;
                    return false;
                }
                bl = true;
            } while (bl);
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Value sum(@NotNull Matrix $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Matrix) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (((Collection)$this.getRows()).size() != ((Collection)((Matrix)right).getRows()).size() || ((Collection)$this.getColumns()).size() != ((Collection)((Matrix)right).getColumns()).size()) {
                    throw new UnsupportedOperationException("Cannot sum matrices with different sizes");
                }
                java.lang.Iterable iterable = CollectionsKt.zip((java.lang.Iterable)$this.getRows(), (java.lang.Iterable)((Matrix)right).getRows());
                MatrixFactory matrixFactory = MatrixFactory.INSTANCE;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((java.lang.Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv2;
                    void rows;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    java.lang.Iterable $this$map$iv2 = CollectionsKt.zip((java.lang.Iterable)((java.lang.Iterable)rows.getFirst()), (java.lang.Iterable)((java.lang.Iterable)rows.getSecond()));
                    boolean $i$f$map2 = false;
                    java.lang.Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((java.lang.Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        Pair pair2 = (Pair)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(((Value)it.getFirst()).sum((Value)it.getSecond()));
                    }
                    collection.add((List)destination$iv$iv2);
                }
                return matrixFactory.instantiate((List)destination$iv$iv);
            }
            return Iterable.DefaultImpls.sum($this, right);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Value multiply(@NotNull Matrix $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (right instanceof Matrix) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (((Collection)$this.getColumns()).size() != ((Collection)((Matrix)right).getRows()).size()) {
                    throw new UnsupportedOperationException("Cannot multiply matrices with incompatible sizes");
                }
                java.lang.Iterable iterable = $this.getRows();
                MatrixFactory matrixFactory = MatrixFactory.INSTANCE;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((java.lang.Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv2;
                    List list = (List)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    java.lang.Iterable $this$map$iv2 = ((Matrix)right).getColumns();
                    boolean $i$f$map2 = false;
                    java.lang.Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((java.lang.Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void $this$reduce$iv;
                        void $this$mapTo$iv$iv3;
                        void column;
                        void row;
                        List list2 = (List)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        java.lang.Iterable $this$map$iv3 = CollectionsKt.zip((java.lang.Iterable)((java.lang.Iterable)row), (java.lang.Iterable)((java.lang.Iterable)column));
                        boolean $i$f$map3 = false;
                        java.lang.Iterable iterable3 = $this$map$iv3;
                        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((java.lang.Iterable)$this$map$iv3, (int)10));
                        boolean $i$f$mapTo32 = false;
                        for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                            void it;
                            Pair pair = (Pair)item$iv$iv3;
                            Collection collection3 = destination$iv$iv3;
                            boolean bl3 = false;
                            collection3.add(((Value)it.getFirst()).multiply((Value)it.getSecond()));
                        }
                        $this$map$iv3 = (List)destination$iv$iv3;
                        boolean $i$f$reduce = false;
                        Iterator iterator$iv = $this$reduce$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw new UnsupportedOperationException("Empty collection can't be reduced.");
                        }
                        Object accumulator$iv = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void b;
                            Value $i$f$mapTo32 = (Value)iterator$iv.next();
                            Value a = (Value)accumulator$iv;
                            boolean bl4 = false;
                            accumulator$iv = a.sum((Value)b);
                        }
                        collection2.add((Value)accumulator$iv);
                    }
                    collection.add((List)destination$iv$iv2);
                }
                return matrixFactory.instantiate((List)destination$iv$iv);
            }
            return Iterable.DefaultImpls.multiply($this, right);
        }

        @NotNull
        public static String getAlgorithmString(@NotNull Matrix $this) {
            return Iterable.DefaultImpls.getAlgorithmString($this);
        }

        public static int getMainPrecedence(@NotNull Matrix $this) {
            return Iterable.DefaultImpls.getMainPrecedence($this);
        }

        public static boolean lessThan(@NotNull Matrix $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Iterable.DefaultImpls.lessThan($this, right);
        }

        @NotNull
        public static Value divide(@NotNull Matrix $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Iterable.DefaultImpls.divide($this, right);
        }

        @NotNull
        public static Value remainder(@NotNull Matrix $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Iterable.DefaultImpls.remainder($this, right);
        }

        @NotNull
        public static Value raise(@NotNull Matrix $this, @NotNull Value right) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return Iterable.DefaultImpls.raise($this, right);
        }

        private static CharSequence _get_rawString_$lambda$4$lambda$3(Value it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getRawString();
        }

        private static CharSequence _get_rawString_$lambda$4(List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return CollectionsKt.joinToString$default((java.lang.Iterable)it, (CharSequence)", ", null, null, (int)0, null, DefaultImpls::_get_rawString_$lambda$4$lambda$3, (int)30, null);
        }

        private static CharSequence _get_laTeXString_$lambda$6$lambda$5(Value it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getLaTeXString();
        }

        private static CharSequence _get_laTeXString_$lambda$6(List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return CollectionsKt.joinToString$default((java.lang.Iterable)it, (CharSequence)" & ", null, null, (int)0, null, DefaultImpls::_get_laTeXString_$lambda$6$lambda$5, (int)30, null);
        }
    }
}

