/*
 * Decompiled with CFR 0.152.
 */
package benchmarks;

import benchmarks.Runner;
import dev.marksman.collectionviews.NonEmptyVector;
import dev.marksman.composablerandom.Generate;
import dev.marksman.composablerandom.RandomState;
import dev.marksman.composablerandom.domain.Characters;
import java.util.Arrays;

public class BenchmarkSandbox {
    private static final int ITERATIONS = 5000000;

    private static void runTuples() {
        int iterations = 500000;
        Generate g = Generate.tupled((Generate)Generate.generateInt(), (Generate)Generate.generateFloat(), (Generate)Generate.generateDouble(), (Generate)Generate.generateLong(), (Generate)Generate.generateBoolean(), (Generate)Generate.generateByte(), (Generate)Generate.generateShort(), (Generate)Generate.tupled((Generate)Generate.chooseOneOfValues((Object)"foo", (Object[])new String[]{"bar", "baz"}), (Generate)Generate.chooseOneFromCollection(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8))));
        Runner.runMark3("tuple", iterations, g);
        Runner.run("tuple", iterations, g);
        Runner.runTraced("tuple", iterations, g);
    }

    private static void sandbox1() {
        Runner.runMark3("int", 5000000, Generate.generateInt());
        Runner.runMark3("float", 5000000, Generate.generateFloat());
        Runner.runMark3("double", 5000000, Generate.generateDouble());
        Runner.runMark3("long", 5000000, Generate.generateLong());
        Runner.runMark3("boolean", 5000000, Generate.generateBoolean());
        Runner.runMark3("byte", 5000000, Generate.generateByte());
        Runner.runMark3("short", 5000000, Generate.generateShort());
        Runner.runMark3("gaussian", 5000000, Generate.generateGaussian());
        System.out.println("---");
        Runner.runRandomState("nextInt", 5000000, RandomState::nextInt);
        Runner.runRandomState("nextFloat", 5000000, RandomState::nextFloat);
        Runner.runRandomState("nextDouble", 5000000, RandomState::nextDouble);
        Runner.runRandomState("nextLong", 5000000, RandomState::nextLong);
        Runner.runRandomState("nextBoolean", 5000000, RandomState::nextBoolean);
        Runner.runRandomState("nextGaussian", 5000000, RandomState::nextGaussian);
    }

    private static void sandbox2() {
    }

    private static void sandbox3() {
        Generate g = Generate.generateInt((int)1, (int)65537).flatMap(i -> Generate.generateLong((long)i.intValue(), (long)(i + 1000))).flatMap(l -> Generate.generateString((int)(l.intValue() & 0x1F), (Generate)Generate.generateStringFromCharacters((NonEmptyVector)Characters.alphaLower())));
        Runner.runMark3("sandbox3", 100000, g);
        Runner.run("sandbox3", 100000, g);
        Runner.runTraced("sandbox3", 100000, g);
    }

    public static void main(String[] args) {
        BenchmarkSandbox.runTuples();
        BenchmarkSandbox.sandbox3();
    }
}

