/*
 * Decompiled with CFR 0.152.
 */
package benchmarks;

import com.jnape.palatable.lambda.functions.Fn1;
import dev.marksman.composablerandom.DefaultInterpreter;
import dev.marksman.composablerandom.Generate;
import dev.marksman.composablerandom.GeneratedStream;
import dev.marksman.composablerandom.Generator;
import dev.marksman.composablerandom.Interpreter;
import dev.marksman.composablerandom.Parameters;
import dev.marksman.composablerandom.RandomState;
import dev.marksman.composablerandom.Result;
import dev.marksman.composablerandom.StandardParameters;
import dev.marksman.composablerandom.TracingInterpreter;
import dev.marksman.composablerandom.legacy.DefaultInterpreterMark3;
import dev.marksman.composablerandom.primitives.ConstantImpl;
import dev.marksman.composablerandom.random.StandardGen;

public class Runner {
    public static <A> void runMark3(String label, int iterations, Generate<A> gen) {
        Generator compiled = DefaultInterpreterMark3.defaultInterpreter((Parameters)StandardParameters.defaultParameters()).compile(gen);
        StandardGen current = StandardGen.initStandardGen();
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            Result result = compiled.run((RandomState)current);
            current = (RandomState)result.getNextState();
        }
        long t = System.currentTimeMillis() - t0;
        System.out.println("mark 3 " + label + ": " + t + " ms");
    }

    public static <A> void run(String label, int iterations, Generate<A> gen) {
        Interpreter overrides = Interpreter.interpreter((ctx, g) -> {
            if (g instanceof Generate.NextInt) {
                return ConstantImpl.constantImpl((Object)1);
            }
            return ctx.callNextHandler(g);
        });
        Interpreter interpreter = DefaultInterpreter.defaultInterpreter().overrideWith(overrides);
        Generator compiled = interpreter.compile((Parameters)StandardParameters.defaultParameters(), gen);
        StandardGen current = StandardGen.initStandardGen();
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            Result result = compiled.run((RandomState)current);
            current = (RandomState)result.getNextState();
        }
        long t = System.currentTimeMillis() - t0;
        System.out.println(label + ": " + t + " ms");
    }

    public static <A> void runTraced(String label, int iterations, Generate<A> gen) {
        Generator compile = TracingInterpreter.tracingInterpreter().compile(gen);
        GeneratedStream stream = GeneratedStream.streamFrom((Generator)compile, (RandomState)StandardGen.initStandardGen());
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            stream.next();
        }
        long t = System.currentTimeMillis() - t0;
        System.out.println("traced " + label + ": " + t + " ms");
    }

    public static <A> void runRandomState(String label, int iterations, Fn1<RandomState, Result<? extends RandomState, A>> fn) {
        StandardGen currentState = StandardGen.initStandardGen();
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            Result result = (Result)fn.apply((Object)currentState);
            currentState = (RandomState)result.getNextState();
        }
        long t = System.currentTimeMillis() - t0;
        System.out.println("RandomState " + label + ": " + t + " ms");
    }
}

