/*
 * Decompiled with CFR 0.152.
 */
package dev.marksman.composablerandom;

import com.jnape.palatable.lambda.adt.hlist.HList;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn1.Id;
import com.jnape.palatable.lambda.functions.builtin.fn2.All;
import com.jnape.palatable.lambda.functions.builtin.fn2.Eq;
import dev.marksman.composablerandom.DefaultInterpreter;
import dev.marksman.composablerandom.FrequencyEntry;
import dev.marksman.composablerandom.Generate;
import dev.marksman.composablerandom.GeneratedStream;
import dev.marksman.composablerandom.Generator;
import dev.marksman.composablerandom.Parameters;
import dev.marksman.composablerandom.RandomState;
import dev.marksman.composablerandom.Result;
import dev.marksman.composablerandom.StandardParameters;
import dev.marksman.composablerandom.random.StandardGen;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GeneratorTest {
    private static final int SEQUENCE_LENGTH = 17;
    private static final Generate<Integer> gen1 = Generate.generateInt();
    private static final Generate<Double> gen2 = Generate.generateGaussian();
    private static final Generate<Integer> gen3 = Generate.generateIntExclusive((int)1, (int)10);
    private static final Generate<String> gen4 = Generate.frequency((FrequencyEntry)FrequencyEntry.entryForValue((int)3, (Object)"foo"), (FrequencyEntry[])new FrequencyEntry[]{FrequencyEntry.entryForValue((int)7, (Object)"bar")});

    GeneratorTest() {
    }

    @Test
    void functorIdentity() {
        GeneratorTest.testFunctorIdentity(gen1);
        GeneratorTest.testFunctorIdentity(gen2);
        GeneratorTest.testFunctorIdentity(gen3);
        GeneratorTest.testFunctorIdentity(gen4);
    }

    @Test
    void functorComposition() {
        GeneratorTest.testFunctorComposition(gen1);
        GeneratorTest.testFunctorComposition(gen2);
        GeneratorTest.testFunctorComposition(gen3);
        GeneratorTest.testFunctorComposition(gen4);
    }

    @Test
    void monadLeftIdentity() {
        GeneratorTest.testMonadLeftIdentity(1, gen1);
        GeneratorTest.testMonadLeftIdentity(0.0, gen2);
        GeneratorTest.testMonadLeftIdentity(1, gen3);
        GeneratorTest.testMonadLeftIdentity("foo", gen4);
    }

    @Test
    void monadRightIdentity() {
        GeneratorTest.testMonadRightIdentity(gen1);
        GeneratorTest.testMonadRightIdentity(gen2);
        GeneratorTest.testMonadRightIdentity(gen3);
        GeneratorTest.testMonadRightIdentity(gen4);
    }

    @Test
    void generateConstant() {
        Assertions.assertTrue((boolean)All.all((Fn1)Eq.eq((Object)1), (Iterable)GeneratedStream.streamFrom((Generate)Generate.constant((Object)1)).next(1000)));
    }

    private static <A> void testFunctorIdentity(Generate<A> gen) {
        Generate generator2 = gen.fmap((Fn1)Id.id());
        GeneratorTest.testEquivalent(gen, generator2);
    }

    private static <A> void testFunctorComposition(Generate<A> gen) {
        Fn1 f = a -> HList.tuple((Object)a, (Object)a);
        Fn1 g = t -> t.cons(t._1());
        GeneratorTest.testEquivalent(gen.fmap(f).fmap(g), gen.fmap(f.fmap(g)));
    }

    private static <A> void testMonadLeftIdentity(A someValue, Generate<A> gen) {
        Fn1 fn = Id.id().fmap(arg_0 -> gen.pure(arg_0));
        Generate generator1 = (Generate)fn.apply(someValue);
        Generate generator2 = gen.pure(someValue).flatMap(fn);
        GeneratorTest.testEquivalent(generator1, generator2);
    }

    private static <A> void testMonadRightIdentity(Generate<A> gen) {
        Generate generator2 = gen.flatMap(arg_0 -> gen.pure(arg_0));
        GeneratorTest.testEquivalent(gen, generator2);
    }

    private static <A> void testEquivalent(Generate<A> gen1, Generate<A> gen2) {
        StandardGen initial = StandardGen.initStandardGen();
        Result<RandomState, A> result1 = GeneratorTest.run(Generate.generateArrayListOfN((int)17, gen1), (RandomState)initial);
        Result<RandomState, A> result2 = GeneratorTest.run(Generate.generateArrayListOfN((int)17, gen2), (RandomState)initial);
        Assertions.assertEquals((Object)result1.getNextState(), (Object)result2.getNextState(), (String)"outbound RandomGens don't match");
        Assertions.assertEquals((Object)result1.getValue(), (Object)result2.getValue(), (String)"values don't match");
    }

    private static <A> Result<RandomState, A> run(Generate<A> gen, RandomState input) {
        Generator compiled = DefaultInterpreter.defaultInterpreter().compile((Parameters)StandardParameters.defaultParameters(), gen);
        return compiled.run(input);
    }
}

